import re
from typing import Any, Dict, Mapping, Optional

_correlation_headers_pattern = re.compile(
    r'(correlation|flow-id|request-id|response-id)+', re.IGNORECASE
)


def extract_correlation_headers(headers: Optional[Mapping[str, Any]]) -> Dict[str, Any]:
    headers = headers or {}
    extracted = {}

    for key, value in headers.items():
        if _correlation_headers_pattern.search(key) is not None:
            extracted[key] = value

    return extracted
