import marshmallow as mm
import ujson


class BaseSchema(mm.Schema):
    SKIP_NONE: bool = False

    @mm.post_dump
    def remove_none_values(self, data, **kwargs):
        if not self.SKIP_NONE:
            return data

        return {
            key: value for key, value in data.items()
            if value is not None
        }

    class Meta:
        json_module = ujson
        strict = True
