from decimal import Decimal

from .base import BaseSchema
from .fields import AmountField, BytesField


class CamelCaseSchema(BaseSchema):
    TYPE_MAPPING = {Decimal: AmountField, bytes: BytesField}
    CAPITAL_FIRST_LETTER = False

    def on_bind_field(self, field_name, field_obj):
        words = field_name.split('_')
        first_word = (words[0].title() if self.CAPITAL_FIRST_LETTER else words[0])
        camel_case_name = first_word + ''.join(x.title() for x in words[1:])
        if field_obj.dump_to is None:
            field_obj.dump_to = camel_case_name
        if field_obj.load_from is None:
            field_obj.load_from = camel_case_name
