from typing import Callable, Iterable, Type, TypeVar

import marshmallow as mm

TSchema = TypeVar('TSchema', bound=mm.Schema)


def skip_none_on_dump(field_names: Iterable[str]) -> Callable[[Type[TSchema]], Type[TSchema]]:
    def _skip_none_fields(schema_cls: Type[TSchema]) -> Type[TSchema]:
        class SkippingNullsSchema(schema_cls):  # type: ignore[valid-type,misc]
            @mm.post_dump
            def skip_none_fields(self, data, **kwargs):
                for field in field_names:
                    if field in data and data[field] is None:
                        del data[field]
                return data

        return SkippingNullsSchema
    return _skip_none_fields
