import logging
from typing import Dict, Any

import asyncpg
import sqlalchemy as sa
from asyncpgsa import compile_query

log = logging.getLogger(__name__)


async def async_qexec(dsn, query, vars: Dict[str, Any] = None, ssl=None):
    c_query, c_params = compile_query(sa.text(query).params(**(vars or {})))
    column_names, rows = None, None
    connection: asyncpg.Connection = await asyncpg.connect(dsn=dsn, ssl=ssl)
    try:
        st = await connection.prepare(c_query)
        column_names = [a.name for a in st.get_attributes()]
        rows = await st.fetch(*c_params)
    except asyncpg.PostgresError as error:
        log.error(f'failed query: {query}')
        log.exception(error)
        raise error
    finally:
        await connection.close()
        return column_names, rows
