from dataclasses import dataclass
from typing import List
from collections import deque


@dataclass
class DbHost:
    dsn: str
    geo: str = None
    primary: bool = False
    health_check_limit: int = 1

    def __post_init__(self):
        self.__death_history = deque(maxlen=self.health_check_limit)

    @property
    def tier(self):
        return 'primary' if self.primary else 'replica'

    def __hash__(self):
        return hash((self.dsn, self.geo))

    @property
    def dead(self):
        return (2 * sum(self.__death_history)) > len(self.__death_history)

    @dead.setter
    def dead(self, val: bool):
        self.__death_history.append(val)


@dataclass
class Db:
    hosts: List[DbHost]
