import os
from enum import unique, Enum


@unique
class EnvType(Enum):
    Test = 'test'
    Prod = 'prod'
    Corp = 'corp'
    Local = 'local'
    Docker = 'docker'
    Devpack = 'devpack'
    Load = 'load'

    @classmethod
    def _missing_(cls, value):
        for env_type, text_aliases in [
            (EnvType.Test, ['testing']),
            (EnvType.Prod, ['production', 'public-production']),
            (EnvType.Corp, ['intranet-production', 'yt-production']),
        ]:
            if value in text_aliases:
                return env_type
        return super()._missing_(value)


def qloud_env():
    env = os.environ.get('QLOUD_ENVIRONMENT')
    return env and EnvType(env)
