import os.path
import ujson
import re
import socket


def gethostname():
    '''Get host FQDN'''

    qloud_meta_path = '/etc/qloud/meta.json'
    if os.path.exists(qloud_meta_path):
        with open(qloud_meta_path) as fd:
            data = ujson.load(fd)
            component_name = re.compile('^(?P<comp_name>.*)-\d+').match(data["qloud_instance"])["comp_name"]

            return '.'.join((
                data["qloud_instance"],
                component_name,
                data["qloud_environment"],
                data["qloud_application"],
                data["qloud_project"],
                "stable.qloud-d.yandex.net",
            ))
    return socket.gethostname()
