from logging.handlers import WatchedFileHandler
from queue import Queue
from threading import Thread

from mail.python.theatre.app.log_helpers.json_logs import ExtraJsonFormatter


class AsyncFileHandler(WatchedFileHandler):
    def __init__(self, *args, **kwargs):
        super(AsyncFileHandler, self).__init__(*args, **kwargs)
        self.__queue = Queue()
        self.__thread = Thread(target=self.__loop, daemon=True)
        self.__thread.start()

    def emit(self, record):
        self.__queue.put(record)

    def stop(self):
        self.__queue.put(None)
        self.__thread.join()

    def __loop(self):
        while True:
            record = self.__queue.get()
            if record is None:
                return
            try:
                super(AsyncFileHandler, self).emit(record)
            except:
                pass


def file_handler(path, level=None):
    # hdlr = AsyncFileHandler(str(path), mode='a', encoding='utf-8')
    hdlr = WatchedFileHandler(str(path), mode='a', encoding='utf-8')
    if level:
        hdlr.setLevel(level)
    hdlr.setFormatter(ExtraJsonFormatter())
    return hdlr
