import logging
from datetime import timedelta

import asyncpg
from ssl import SSLContext

from mail.python.theatre.roles import Cron
from mail.python.theatre.app.db_helpers.async_qexec import async_qexec
from mail.python.theatre.app.db_helpers.types import Db

log = logging.getLogger(__name__)


async def is_replica(dsn, ssl=None):
    _, rows = await async_qexec(dsn, "select pg_is_in_recovery()", ssl=ssl)
    return rows[0][0]


class DbTierPoller(Cron):
    def __init__(
        self,
        db: Db,
        ssl: SSLContext,
        run_every: timedelta
    ):
        self._db = db
        self._ssl = ssl
        super().__init__(job=self._job, run_every=run_every)

    async def _job(self):
        for host in self._db.hosts:
            try:
                host.primary = not await is_replica(host.dsn, self._ssl)
                host.dead = False
            except asyncpg.PostgresError as err:
                log.error('error in polling host {addr}: {err}'.format(addr=host.dsn, err=err))
                host.dead = True
