import backoff
from dataclasses import dataclass


@dataclass
class BackoffSettings:
    max_time_sec: float
    max_tries: int

    def on_exception(self, *args, **kwargs):
        return backoff.on_exception(*args, max_time=self.max_time_sec, max_tries=self.max_tries, **kwargs)

    def on_predicate(self, *args, **kwargs):
        return backoff.on_predicate(*args, max_time=self.max_time_sec, max_tries=self.max_tries, **kwargs)
