from mail.python.theatre.app.env import EnvType


class SettingsNode:
    @classmethod
    def from_env(cls, env: EnvType):
        return cls().configure(env)

    def prod(self):
        pass

    def corp(self):
        pass

    def test(self):
        pass

    def load(self):
        pass

    def devpack(self):
        pass

    def docker(self):
        pass

    def local(self):
        pass

    def configure(self, env: EnvType):
        self._configure_node(env)
        for node in self.nodes:
            node.configure(env)
        return self

    def _configure_node(self, env: EnvType):
        return {
            EnvType.Test: self.test,
            EnvType.Prod: self.prod,
            EnvType.Corp: self.corp,
            EnvType.Load: self.load,
            EnvType.Local: self.local,
            EnvType.Docker: self.docker,
            EnvType.Devpack: self.devpack,
        }.get(env, self.local)()

    def as_dict(self) -> dict:
        return {attr: getattr(self, attr) for attr in self.settings}

    @property
    def settings(self):
        return [
            attr for attr in dir(self)
            if attr.upper() == attr and not attr.startswith('_') and not isinstance(attr, SettingsNode)
        ]

    @property
    def nodes(self):
        for attr_name in dir(self):
            attr = getattr(self, attr_name)
            if isinstance(attr, SettingsNode):
                yield attr
