from pathlib import Path
from dataclasses import dataclass
from typing import List

from .base import SettingsNode


@dataclass
class CustomLogger:
    logger: str = None
    file: str = None

    def get_logger(self):
        from logging import getLogger
        return getLogger('custom.' + self.logger)


class LogSettings(SettingsNode):
    level = 'info'
    dir_path: Path = None
    custom_loggers: List[CustomLogger] = []

    def local(self):
        self.level = 'debug'

    def docker(self):
        self.level = 'debug'
