###Как заполучить себе dbstats

0. Проверить пререквизиты:
    * Есть запущенный PostgreSQL, например в MDB. Есть пользователь, который может читать нужное из БД
    * Пароль от пользователя БД лежит в YaVault plain-text'ом. У вас есть доступ до этого секрета
    * Есть проект в Deploy и пара ядер железа в квоте. У вас есть права на деплой
    * Есть сетевой макрос для запуска в Deploy. У вас есть на него права
    * Есть проект в Solomon, куда будут слаться метрики. У вас есть права на редактирование


1. Скопировать себе проект с конфигами:
    ```bash
    > cookiecutter example -o path/to/my/dir
    ```
   Попутно `cookiecutter` попросит заполнить конфиг:
    * `project_name`: snake_case литерал, который прорастет в название папки с проектом и всякое такое
    * `db_*`: как и куда подключаться к БД. Хосты указываются списком, через запятую
    * `abc_service_id`: Чиселка со странички проекта в abc.yandex-team.ru.
      Из этого проекта Deploy возьмет квоту железа
    * `solomon_*`: Настройки Соломон-агента, с каким проектом/сервисом поставлять метрики
    * `deploy_project`: Ваш проект в Deploy
    * `deploy_stage`: Имя для нового стейджа с dbstats (по-умолчанию будет `project_name`)
    * `net_macro`: Сетевой макрос, в котором запускать dbstats
    * `yavault_dbpassword_`: Идентификаторы секрета, в котором лежит пароль от БД

   В результате по пути `path/to/my/dir/{{project_name}}` будут лежать:
    * Конфиги для приложения и solomon-agent
    * Конфиг для Deploy
    * Makefile для удобного обновления статических ресурсов из конфигов и деплоя

2. Добавить директорию в `arc`:
   ```bash
   arc add path/to/my/dir/{{project_name}} && arc commit
   ```

3. Докидать нужных запросов в файл `pg-dbstats/config.yaml`
   * Можно писать запросы в конфиг самого приложения
   * Можно выносить запросы в отдельный `query.conf.sql` конфиг. В этом случае
     большинство редакторов понимают, что в файле SQL-запросы.
     Запросы из `query.conf.sql` адресуются в основном конфиге через `name`,
     который указывается в комментарии перед запросом.


4. Перейти в директорию и сказать `make all`. Что произойдёт:
   * Каждый конфиг-файл зальётся в Sandbox, результат заливки сохранится в `resources/`.
     Если конфиг отредактировать — при следующем вызове `make all` он перезальётся.
   * Актуальные версии ресурсов прописываются в `deploy`-конфиг скриптом `deploy/update_resource.py`
   * Создастся stage в Deploy через `dctl`

   Последующие правки в конфигах деплоятся так же, через `make all`.

5. Сохранить изменения в arc.


6. Пойти в Solomon и настроить cluster и shard под настройки, заданные в cookiecutter:
   * Создать `cluster` и/или `service` , если решили использовать новое значение
   * Добавить в `cluster` по записи в `Cluster hosts` на каждый ДЦ с dbstats
   * Если заводили новый `cluster/service` для dbstats - заведите новый `shard`

   Подсмотреть настройки можно в `solomon/solomon-{{project_name}}.conf`


7. Готово, вы восхитительны! Наслаждайтесь сигналами в Solomon.
