from typing import Mapping, Any

from mail.python.theatre.app.settings.db import DbSettings
from mail.python.theatre.stages.db_stats.types import Db, DbHost


def db_settings_from_config(datasource_config: Mapping[str, str], fqdn: str) -> DbSettings:
    settings = DbSettings()
    settings.port = datasource_config['port']
    settings.name = datasource_config['dbname']
    settings.user = datasource_config['user']
    settings.password = datasource_config['password']
    settings.host = fqdn
    return settings


def make_db_source(db_config: Mapping[str, Any]) -> Db:
    print(db_config)
    return Db(
        prj=db_config['dbname'],
        hosts=[
            DbHost(
                dsn=db_settings_from_config(db_config, fqdn=host['fqdn']).pg_dsn(),
                geo=host['geo'],
            )
            for host in db_config['hosts']
        ]
    )
