from typing import Type

from mail.python.theatre.stages.db_stats.roles.db_stat_poller import (
    DbStatPoller, MetricWithTags, MetricsWithTags, convert_value
)


def named_signal(poller_cls: Type[DbStatPoller]):
    """
    В качестве названия метрики использует DbSignal.name вместо первой колонки из результатов запроса.
    Стало удобно с появлением в Соломоне пользовательских меток - не надо кастомизировать название сигнала на каждый чих
    """
    class NamedSignalPoller(poller_cls):
        def _get_signals_from_row(self, column_names, rows, with_tags) -> MetricsWithTags:
            return [
                MetricWithTags(
                    metric=(
                        self._db_signal.name,
                        convert_value(row[-1])),
                    tags={
                        tag.lower(): row[num]
                        for num, tag in enumerate(column_names[0:-1])
                        if row[num] is not None
                    }
                )
                for row in rows
            ]
    return NamedSignalPoller
