import logging


class CustomAdapter(logging.LoggerAdapter):
    def process(self, msg, kwargs):
        def get_value(args, name, typ):
            my_val = args.pop(name, None)
            try:
                return typ(my_val)
            except:
                return None

        kwargs['extra'] = {}
        for k, t in self.extra.items():
            kwargs['extra'][k] = get_value(kwargs, k, t)
        return msg, kwargs
