from contextlib import contextmanager
import random
import string

from contextvars import ContextVar

REQUEST_ID = ContextVar('request-id', default=None)


@contextmanager
def set_request_id(prefix: str, value: str = None):
    if value is None:
        value = f"{prefix}_{''.join(random.choices(string.digits + 'abcdef', k=12))}"
    token = REQUEST_ID.set(value)
    yield value
    REQUEST_ID.reset(token)
