import ujson
from aiohttp import ClientSession, ClientTimeout

from .base import Attendant


class HttpPooled(Attendant):
    """
    Role that holds aiohttp ClientSession object that is actually http sessions pool
        that can be shared among coroutines.
    One can use it as mixin with other roles. In that case, MRO matters, if graceful HTTP-connections shutdown
        is desired, better place that mixin first in inheritance list.
    """
    def __init__(self, session: ClientSession = None, timeout: ClientTimeout = None, **kwargs):
        super().__init__(**kwargs)
        if session is not None:
            assert timeout is None, 'Both session and timeout are provided, choose one'
        else:
            assert timeout is not None, 'Both session and timeout are not provided, choose one'
            session = ClientSession(timeout=timeout, json_serialize=ujson.dumps)
        self.http_session = session

    async def start(self):
        await self.http_session.__aenter__()
        await super().start()

    async def stop(self):
        await super().stop()
        await self.http_session.__aexit__(None, None, None)
