import logging
from contextlib import asynccontextmanager
from aiopg.sa import Engine

log = logging.getLogger(__name__)


class DbEngine(object):
    def __init__(self, pg: Engine):
        self._pg = pg

    @asynccontextmanager
    async def acquire(self):
        async with self._pg.acquire() as conn:
            try:
                yield conn
            except Exception as exc:
                log.error('Exception during request to db: %s', exc)
                conn.connection.close()
                await conn.close()
                raise exc
