from dataclasses import dataclass

import sqlalchemy as sa


class WorkersTable(sa.Table):
    def __init__(
        self,
        name: str,
        metadata: sa.MetaData,
        c_name: sa.Column,
        c_heartbeat: sa.Column,
        *args,
        **kwargs
    ):
        super().__init__(name, metadata, c_name, c_heartbeat, *args, **kwargs)
        self.c_name = c_name
        self.c_heartbeat = c_heartbeat

    @classmethod
    def default(cls, metadata: sa.MetaData, table_name: str = 'workers'):
        return cls(
            table_name,
            metadata,
            sa.Column('worker', sa.Text()),
            sa.Column('heartbeated', sa.DateTime(timezone=True)),
        )


class BucketsTable(sa.Table):
    def __init__(
        self,
        name: str,
        metadata: sa.MetaData,
        c_id: sa.Column,
        c_worker_name: sa.Column,
        c_heartbeat: sa.Column,
        *args,
        **kwargs
    ):
        super().__init__(name, metadata, c_id, c_worker_name, c_heartbeat, *args, **kwargs)
        self.c_id = c_id
        self.c_worker_name = c_worker_name
        self.c_heartbeat = c_heartbeat

    @classmethod
    def default(cls, metadata: sa.MetaData, table_name: str = 'buckets'):
        return cls(
            table_name,
            metadata,
            sa.Column('bucket_id', sa.Text()),
            sa.Column('worker', sa.Text()),
            sa.Column('heartbeat', sa.DateTime(timezone=True)),
        )


@dataclass
class BucketsMetainfo:
    metadata: sa.MetaData
    t_workers: WorkersTable
    t_buckets: BucketsTable

    @classmethod
    def default(cls, schema='buckets'):
        metadata = sa.MetaData(schema=schema)
        return cls(
            metadata=metadata,
            t_workers=WorkersTable.default(metadata=metadata),
            t_buckets=BucketsTable.default(metadata=metadata),
        )
