from aiopg.sa import Engine

from mail.python.theatre.roles import Director as DirectorBase
from mail.python.theatre.stages.bucket_holder.interactions.db.meta import BucketsMetainfo
from mail.python.theatre.stages.bucket_holder.settings.app import AppSettings
from .bucket_holder import BucketHolder
from .buckets_processor import BucketsProcessor, ProcessorFactoryT
from .rebalancer import Rebalancer
from ..interactions.db.buckets import BucketsQueries


class Director(DirectorBase):
    def __init__(
            self,
            pg: Engine,
            worker_name: str,
            factory: ProcessorFactoryT,
            settings: AppSettings,
            db_meta: BucketsMetainfo = None,
    ):
        db_meta = db_meta or BucketsMetainfo.default()
        self.pg = pg
        self.queries = BucketsQueries(pg, worker_name, db_meta)
        self.holder = BucketHolder(queries=self.queries, settings=settings.holder)
        self.processor = BucketsProcessor(processor_factory=factory)
        self.rebalancer = Rebalancer(
            queries=self.queries,
            holder=self.holder,
            processor=self.processor,
            settings=settings.rebalancer
        )
        super().__init__(tasks=(
            self.holder,
            self.processor,
            self.rebalancer,
        ))

    async def stop(self):
        await super().stop()
        self.pg.close()
        await self.pg.wait_closed()
