from typing import TypeVar, Optional

BucketId = TypeVar('BucketId')


def get_shard_id(bucket_id: BucketId) -> int:
    return int(bucket_id.split(",")[0])


def make_bucket_id(shard_id: int, husky_cluster: Optional[str]) -> BucketId:
    return str(shard_id) + "," + husky_cluster if husky_cluster is not None else str(shard_id)
