import logging
import aiopg
import psycopg2

log = logging.getLogger(__name__)


async def async_qexec(dsn, query, vars=None):
    try:
        async with aiopg.connect(dsn) as conn:
            async with conn.cursor() as cursor:
                await cursor.execute(query, vars)
                column_names = [desc[0] for desc in cursor.description]
                rows = [row async for row in cursor]
                return column_names, rows
    except psycopg2.Error as error:
        log.error(f'failed query: {query}')
        log.exception(error)
        raise error
