from datetime import timedelta
import psycopg2
import aiopg
from mail.python.theatre.roles import Cron
from mail.python.theatre.stages.db_stats.types import Db


async def is_replica(dsn):
    async with aiopg.connect(dsn) as conn:
        async with conn.cursor() as cur:
            await cur.execute('select pg_is_in_recovery()')
            return (await cur.fetchone())[0]


class DbTierPoller(Cron):
    def __init__(
        self,
        db: Db,
        run_every: timedelta
    ):
        self._db = db
        super().__init__(job=self._job, run_every=run_every)

    async def _job(self):
        for host in self._db.hosts:
            try:
                host.primary = not await is_replica(host.dsn)
                host.dead = False
            except psycopg2.Error:
                host.dead = True
