from dataclasses import dataclass, field
from datetime import timedelta
from enum import Enum, unique
from typing import Dict, Any

from mail.python.theatre.app.db_helpers.types import DbHost  # noqa
from mail.python.theatre.app.db_helpers.types import Db as DbBase


@dataclass
class Db(DbBase):
    prj: str = None
    ctype: str = None


@unique
class TierRunPolicy(Enum):
    All = 'all'
    Master = 'master'
    AnyHost = 'any_host'


@dataclass
class DbSignal:
    query: str
    row_signal: bool
    run_every: timedelta
    preserve_on_query_fail: bool = True
    sigopt_suffix: str = 'ammv'
    tier_run_policy: TierRunPolicy = TierRunPolicy.All
    query_args: Dict[str, Any] = field(default=None)
    with_tags: bool = False
    name: str = None
