import asyncio
from typing import Coroutine


class InterceptorLogic:
    async def on_suspend(self):
        pass

    async def on_reenter(self):
        pass


class CoroInterceptor:
    """Wraps coroutine call, allows to set customization points on every suspend and every reentry of coroutine"""
    def __init__(self, logic: InterceptorLogic):
        self.logic = logic

    async def __call__(self, coro: Coroutine):
        while True:
            try:
                fut = coro.send(None)
            except StopIteration as e:
                return e.value
            await self.logic.on_suspend()
            if fut:
                await asyncio.wait([fut])
            await self.logic.on_reenter()
