import builtins
import gzip
import html
import io
import os
import re
import shutil
import sys
from operator import itemgetter
from time import sleep

import paramiko
import pysftp
from yql.api.v1.client import YqlClient

sys.path.append('/nightlyRunner/')
from LogParse.client_part import tskv
from set_secret import set_secret

set_secret.set_secrets()
client = YqlClient(db='hahn', token=os.environ["YQL_TOKEN"])

scriptPath = os.path.dirname(os.path.abspath(__file__))
path_to_test_logs = scriptPath + '/duffman_logs'
message_duffman = []


def print(arg):
    builtins.print(arg)
    message_duffman.append(str(arg))


def load_ir():
    request = client.query(
        r"""
    SELECT m, IR, name, message, reason FROM `home/mailfront/qa/logAlerts/duffmanError/ir_table`
    """,
        syntax_version=1
    )
    request.run()
    ir_for_errors = []
    for table in request.get_results():
        column_names = []
        table.fetch_full_data()
        for column_name, column_type in table.columns:
            column_names.append(column_name)
        k = 0
        for row in table.rows:
            ir_for_errors.append({})
            i = 0
            for cell in row:
                ir_for_errors[k][column_names[i]] = cell if cell != '' else None
                i += 1
            k += 1
    return ir_for_errors


def get_error_color(ir, error):
    color = '#D28000'  # orange
    text = 'can\'t find error in list'
    for ir_error in ir:
        if (error.get('error').get('name') == ir_error.get('name')) & \
                (error.get('error').get('message') == ir_error.get('message')) & \
                (error.get('error').get('reason') == ir_error.get('reason')):
            error_max = float(ir_error['m']) + float(ir_error['IR']) * 2
            error_min = float(ir_error['m']) - float(ir_error['IR']) * 2
            if error_min < 0:
                error_min = 0
            if error['count'] < 4:
                return '', 'not enough data to analyze'
            if error['count'] > float(ir_error['m']) + float(ir_error['IR']) * 2:
                color = 'red'
                text = 'error is more frequent than usual, normal max is: %s' % str(error_max)
            elif error['count'] < float(ir_error['m']) - float(ir_error['IR']) * 2:
                color = 'green'
                text = 'error is more rare than usual, normal min is: %s' % str(error_min)
            else:
                color = 'green'
                text = 'all is fine, boundaries: %s - %s' % (str(error_min), str(error_max))
    return color, text


def import_duffman_files(host, file_name):
    host_prefix = re.search("(ub[0-9]+|pr-[0-9]+|liza-rc-[0-9][0-9]+-[0-9]+)", host).group(1)
    host = 'web-api-1.web-api.%s.verstka-qa.mail.stable.qloud-d.yandex.net' % host_prefix
    print('host: %s' % host)
    my_key = pysftp.RSAKey.from_private_key(io.StringIO(os.environ["SSH_KEY"]), os.environ["SSH_PWD"])
    cnopts1 = pysftp.CnOpts()
    cnopts1.hostkeys = None
    remote_dir = '/ephemeral/var/log/duffman/'
    while os.path.exists(path_to_test_logs):
        print('trying to delete directory')
        shutil.rmtree(path_to_test_logs, ignore_errors=True)
        sleep(1)
    print('directory removed')
    os.makedirs(path_to_test_logs)
    print('directory recreated')
    with pysftp.Connection(host, username='robot-pinkie-pie', private_key=my_key, cnopts=cnopts1) as sftp:
        dir_items_to_remove = []
        dir_items = []
        all_duffman_files = sftp.listdir(remote_dir)
        for dir_item in all_duffman_files:
            if (not re.match('^duffman.*tskv*(gz)?', dir_item)) | ('errors' in dir_item):
                dir_items_to_remove.append(dir_item)
        for dir_item in dir_items_to_remove:
            all_duffman_files.remove(dir_item)
        if file_name == 'duffman*':
            dir_items = all_duffman_files
        else:
            if file_name == 'duffman0':
                for duffman_file in all_duffman_files:
                    if re.match('^duffman.*tskv*.0(gz)?', duffman_file):
                        dir_items.append(duffman_file)
            else:
                if file_name == 'duffman':
                    for duffman_file in all_duffman_files:
                        if re.match('duffman.*tskv$', duffman_file):
                            dir_items.append(duffman_file)
                else:
                    dir_items = [file_name]

    ssh = paramiko.SSHClient()
    ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())
    ssh.connect(host, username='robot-pinkie-pie', pkey=my_key)
    new_items = []
    for dir_item in dir_items:
        cat = 'cat'
        if 'gz' in dir_item:
            cat = 'zcat'
        ssh_stdin, ssh_stdout, ssh_stderr = ssh.exec_command(f" {cat} {remote_dir}{dir_item} | grep -v FINISHED | grep -v RESOLVED | grep -v SUCCESS > {remote_dir}{dir_item}.errors")
        ssh_stdout.channel.recv_exit_status()
        new_items.append(f'{dir_item}.errors')
    print('Connecting to host')
    ssh.close()
    with pysftp.Connection(host, username='robot-pinkie-pie', private_key=my_key, cnopts=cnopts1) as sftp:
        dir_items = new_items
        all_duffman_files = sftp.listdir(remote_dir)
        for dir_item in dir_items:
            for duffman_file in all_duffman_files:
                if re.match(dir_item + '(.gz)?', duffman_file):
                    dir_item = re.match(dir_item + '(.gz)?', duffman_file).group(0)
                    break
            sftp.get(
                remote_dir + str(dir_item),
                localpath=path_to_test_logs + '/logs_' + dir_item,
                preserve_mtime=True
            )
            print('ready ' + dir_item)
    files_in_dir = os.listdir(path_to_test_logs)
    f = open(path_to_test_logs + '/logs', 'a')
    for file_in_dir in files_in_dir:
        print('just file ' + file_in_dir)
        g = open(os.path.join(path_to_test_logs, file_in_dir), errors='ignore')
        shutil.copyfileobj(g, f)
        g.close()
    f.close()


def duffman_log_parse():
    global message_duffman
    message_duffman = []
    columns = [
        'reason',
        'name',
        'message'
    ]
    log_file = open(path_to_test_logs + '/logs', 'r')
    all_logs_list = []
    uniq_log_list = []
    output_log_dict = {}
    output_log_list = []

    for log_string in log_file:
        if not re.search("FINISHED|RESOLVED|SUCCESS", log_string):
            parsed_log_dict = {}
            search_id = re.search("request_id\":\"(.*?)\"}", log_string)
            if search_id:
                log_string = re.sub(search_id.group(1), "", log_string)
            search_ckey = re.search("ckey \((.*?)\)", log_string)
            if search_ckey:
                log_string = re.sub(re.escape(search_ckey.group(1)), "", log_string)
            search_uid = re.search("uid \((.*?)\)", log_string)
            if search_uid:
                log_string = re.sub(search_uid.group(1), "", log_string)
            tskv_log = tskv.loads(log_string)
            for key in tskv_log:
                if key in columns:
                    parsed_log_dict[key] = tskv_log[key]
            all_logs_list.append(parsed_log_dict)

    for log in all_logs_list:
        if log not in uniq_log_list:
            uniq_log_list.append(log)

    for uniq_log in uniq_log_list:
        output_log_dict.update({'count': all_logs_list.count(uniq_log), 'error': uniq_log})
        output_log_list.append(output_log_dict)
        output_log_dict = {}

    ir_table = load_ir()

    print('<pre>')
    for error in sorted(output_log_list, key=itemgetter('count'), reverse=True):
        if ((error.get('error')).get('reason') != 'MODEL_REJECTED') & ((len(error.get('error'))) != 0):
            color, text = get_error_color(ir_table, error)
            if color not in ['green', '']:
                print(
                    '<font color="{}">{:<6} {:<35} {:<30}</font>'.format(
                        color,
                        error.get('count'),
                        html.escape(str(error.get('error'))),
                        text
                    )
                )
    print('</pre>')

    print('<br>')
    print("<h3>MODEL_REJECTED errors distribution</h3>")

    print('<pre>')
    for error in sorted(output_log_list, key=itemgetter('count'), reverse=True):
        if (error.get('error')).get('reason') == 'MODEL_REJECTED':
            color, text = get_error_color(ir_table, error)
            if color not in ['green', '']:
                print(
                    '<font color="{}">{:<6} {:<35} {:<10} {:<30}</font>'.format(
                        color,
                        error.get('count'),
                        error.get('error').get('name'),
                        html.escape(str(error.get('error').get('message'))),
                        text
                    )
                )
    print('</pre>')
    return message_duffman


if __name__ == '__main__':
    host_num = input('Input host number (from 1 to 9): ')
    import_duffman_files(host_num, 'duffman')
    duffman_log_parse()
