import builtins
import os
import pickle
import re

scriptPath = os.path.dirname(os.path.abspath(__file__))
print(scriptPath)
message_jserrors = []


def print(arg):
    builtins.print(arg)
    message_jserrors.append(str(arg))


def save_obj(obj, name):
    with open(scriptPath + '/' + name, 'wb') as f:
        pickle.dump(obj, f, pickle.HIGHEST_PROTOCOL)


def load_obj(name):
    with open(scriptPath + '/' + name, 'rb') as f:
        return pickle.load(f, encoding='UTF-8')


def sort_by_count(logs_to_sort):
    for i in range(len(logs_to_sort) - 1):
        for k in range(len(logs_to_sort) - 1):
            if logs_to_sort[k]["count"] < logs_to_sort[k + 1]["count"]:
                foo = logs_to_sort[k]
                logs_to_sort[k] = logs_to_sort[k + 1]
                logs_to_sort[k + 1] = foo
    return logs_to_sort


def parse_jserrors(obj):
    uniq_errors = []
    logs_to_parse = load_obj(obj)
    for log in logs_to_parse:
        if log["errorType"] == "JSError":
            # print (log)
            log["text"] = jserror_text_optimise(log["text"])
            found = 0
            for uniq_error in uniq_errors:
                if uniq_error["msg"] == log["msg"]:
                    if uniq_error["text"] == log["text"]:
                        uniq_error["count"] += 1
                        found = 1
            if found == 0:
                uniq_errors.append({"count": 1, "msg": log["msg"], "text": log["text"]})
    uniq_errors = sort_by_count(uniq_errors)

    save_obj(uniq_errors, 'logs_test/JSError_testing')


def jserror_text_optimise(text):
    m = re.search("(^|\n)[\w. _':a-яА-Я\\\",\-<>]*: [\w .\-_\'\:a-яА-Я\\\",\-\n<>]*\(", text)
    if m:
        return m.group()
    else:
        m = re.search("[.]*at[\w<>._ ]*\(", text)
        if m:
            return m.group()
        else:
            text = re.sub("^[a-zA-Z0-9\-\:\/\).]*($|\n)", "\n", text)
            text = re.sub("@https.*(\n|\Z)", "\n", text)
            text = re.sub("blob\:.*(\n|\Z)", "\n", text)
            text = re.sub("(^|\n)[a-zA-Z0-9\.\/% ]*handle[a-zA-Z0-9\.\/%\( ]*($|\n)", "\n", text)
            text = text[:240]
        return text


def find_equal_jserror():
    global message_jserrors
    message_jserrors = []
    print('<br>')
    print('<h3>JS errors</h3>')

    parsed_local_handlers = load_obj('logs_test/JSError_testing')
    parsed_yql_handlers = load_obj('logs_prod/JSError_prod')

    if parsed_local_handlers:
        print('<pre>')
        for error in parsed_local_handlers:
            print(str(error["count"]) + '     ' + error["msg"] + '     ' + error["text"])
        print('</pre>')
    else:
        print("No js errors found!")

    print('<pre>')
    for error in parsed_local_handlers:
        is_equal = 0
        for prod_error in parsed_yql_handlers:
            if error["msg"] == prod_error["msg"]:
                # if error["text"] == prod_error["text"]:
                is_equal = 1
        if is_equal != 1:
            print('<font color="red">DIDN\'T FIND ERROR IN PROD :')
            print(error)
            print('</font>')
    print('</pre>')

    return message_jserrors
