import builtins
import os
import pickle
import re

scriptPath = os.path.dirname(os.path.abspath(__file__))
message_promise = []


def print(arg):
    builtins.print(arg)
    message_promise.append(str(arg))


def save_obj(obj, name):
    with open(scriptPath + '/' + name, 'wb') as f:
        pickle.dump(obj, f, pickle.HIGHEST_PROTOCOL)


def load_obj(name):
    with open(scriptPath + '/' + name, 'rb') as f:
        return pickle.load(f, encoding='UTF-8')


def sort_by_count(logs_to_sort):
    for i in range(len(logs_to_sort) - 1):
        for k in range(len(logs_to_sort) - 1):
            if logs_to_sort[k]["count"] < logs_to_sort[k + 1]["count"]:
                foo = logs_to_sort[k]
                logs_to_sort[k] = logs_to_sort[k + 1]
                logs_to_sort[k + 1] = foo
    return logs_to_sort


def parse_promise(obj):
    uniq_errors = []
    logs_to_parse = load_obj(obj)
    for log in logs_to_parse:
        if log["errorType"] == "promise.exception":
            log["text"] = promise_text_optimise(log["text"])
            found = 0
            for uniq_error in uniq_errors:
                if uniq_error["text"] == log["text"]:
                    uniq_error["count"] += 1
                    found = 1
            if found == 0:
                uniq_errors.append({"count": 1, "text": log["text"]})
    uniq_errors = sort_by_count(uniq_errors)

    save_obj(uniq_errors, 'logs_test/promise_testing')


def promise_text_optimise(text):
    text = re.sub("\(https?://(?:[-\w./:])+\)([\s*\S*]*)", "", text)
    text = re.sub("https?://(?:[-\w./:])+", "", text)
    text = re.sub("@https?://(?:[-\w./:])+([\s*\S*]*)", "", text)
    text = re.sub("(/<)+", "", text)

    return text


def find_equal_promise():
    global message_promise
    message_promise = []
    print('<br>')
    print('<h3>Promise errors</h3>')

    parsed_local_handlers = load_obj('logs_test/promise_testing')
    parsed_yql_handlers = load_obj('logs_prod/promise_prod')

    if parsed_local_handlers:
        print('<pre>')
        for error in parsed_local_handlers:
            print(str(error["count"]) + '  ' + error["text"])
        print('</pre>')
    else:
        print("No promise found!")

    print('<pre>')
    for error in parsed_local_handlers:
        is_equal = 0
        for prod_error in parsed_yql_handlers:
            if error["text"] == prod_error["text"]:
                is_equal = 1
        if is_equal != 1:
            print('<font color="red">DIDN\'T FIND ERROR IN PROD :')
            print(error)
            print('</font>')
    print('</pre>')

    return message_promise
