import os
import pickle
import sys

sys.path.append('/set_secret')

import set_secret
from yql.api.v1.client import YqlClient

scriptPath = '/ephemeral/LogParse'

set_secret.set_secrets()
client = YqlClient(db='hahn', token=os.environ["YQL_TOKEN"])

# noinspection PyTypeChecker
request = client.query(
    r"""
$get_day_table_name = @@
import datetime

def get_error_table_name(delta):
    return 'errors-%s' % (datetime.date.today() - datetime.timedelta(days=delta)).strftime("%Y-%m-%d")
@@;

$table_name_days_before = Python::get_error_table_name(Callable<(Int8)->String>, $get_day_table_name);

$parse = Python::parse(Callable<(String?)->String?>, @@
def parse(text):
    # -*- coding: windows-1251 -*-
    import json
    import re
    import ast

    keys = ["reason", "id", "method", "code", "type", "result", "error"]
    text_dict = {}
    text = text.decode("utf-8")
    if "{" in text:
        try:
            text=re.sub("request_id[\\\"\ \:]*[a-zA-Z0-9]*","",text)
            text=re.sub("[a-z0-9]{15,}","",text)
            text = re.sub(",\"\"", "", text)
            try:
                text = ast.literal_eval(text)
                for key in text.keys():
                    if key in keys:
                        text_dict[key] = str(text[key])
            except:
                return text
        except SyntaxError:
            return text
    else:
        return text
    text_dict=str(text_dict)
    return text_dict
@@);

SELECT error_type, name, text, COUNT(*) as c
FROM RANGE(`//home/mailfront`, $table_name_days_before(3), $table_name_days_before(1)) as T
WHERE error_type="HandlerError"
GROUP BY error_type, $parse(text) as text, DictLookup(T.request_dict, "name") as name
HAVING COUNT(*)>1
ORDER BY c DESC;
""",
    syntax_version=1
)

request.run()

for table in request.get_results():
    uniq_errors = []
    column_names = []
    table.fetch_full_data()
    for column_name, column_type in table.columns:
        column_names.append(column_name)
    k = 0
    print(len(table.rows))
    for row in table.rows:
        uniq_errors.append({})
        i = 0
        for cell in row:
            if (column_names[i] == "text") | (column_names[i] == "name"):
                uniq_errors[k][column_names[i]] = cell
            i += 1
        k += 1
    print(len(uniq_errors))

    with open(scriptPath + '/HandlerError_prod', 'wb') as fp:
        pickle.dump(uniq_errors, fp)

    print('\nHandlers Done!')
