import copy
import logging
import os

import requests

FORMAT = '%(asctime)s:%(levelname)s:%(name)s:%(message)s'
logging.basicConfig(level=logging.INFO, format=FORMAT)


class Hitman:
    DATA_FOR_HITMAN_JSON = {
        'requester': '',  # логин пользователя, которому придёт письмо с отчётом
        'properties': {  # проперти процесса в хитмане
            'version': '',
            'special_condition': '',
            'test_stend': '',
            'booking_id': '',
            'booking_regular_id': '',
            'set_ticket_fix_versions': '',
            'requester_code': '',
        }
    }

    def __init__(self, service):
        self.headers_hitman = {
            'Content-Type': 'application/json',
            'Authorization': 'OAuth %s' % os.environ["HITMAN_TOKEN"]
        }
        self.host = 'https://hitman.yandex-team.ru'
        self.service = service

    def send_data_to_hitman(self, requester, testpalm_version, special_condition, test_stend, booking_id,
                            booking_regular_id, startreck_version_name, requester_code):
        data = copy.deepcopy(self.DATA_FOR_HITMAN_JSON)
        data['requester'] = requester
        data['properties']['version'] = testpalm_version
        data['properties']['special_condition'] = special_condition
        data['properties']['test_stend'] = test_stend
        data['properties']['booking_id'] = booking_id
        data['properties']['booking_regular_id'] = str(booking_regular_id)
        data['properties']['set_ticket_fix_versions'] = startreck_version_name
        data['properties']['requester_code'] = requester_code

        logging.info(f'hitman request: {data}')
        resp = requests.post(
            f'{self.host}/api/v1/execution/start/{self.service}',
            verify=False,
            headers=self.headers_hitman,
            json=data
        )
        logging.info(f'hitman response: {resp.text}')
