import logging
import os

from startrek_client import Startrek

FORMAT = '%(asctime)s:%(levelname)s:%(name)s:%(message)s'
logging.basicConfig(level=logging.INFO, format=FORMAT)


class ST:
    def __init__(self, queue):
        self.client = Startrek(
            base_url='https://st-api.yandex-team.ru',
            useragent='robot-pinkie-pie',
            token=os.environ["STARTRECK_TOKEN"]
        )
        self.requester = 'robot-pinkie-pie'
        self.queue = queue

    def create_version(self, version_name):
        version = self.client.versions.create(queue=self.queue, name=version_name)
        logging.info('Version in StarTrack has been created.')
        return version.id

    def create_task_for_testing(self, summary, description, version_id, tp_project, component):
        task = self.client.issues.create(
            queue=self.queue,
            summary=summary,
            type={'name': 'Task'},
            description=description,
            fixVersions=[version_id],
            components=component
        )
        logging.info(f'Task {task.key} in StarTrack has created')
        return task.key

    def create_comment(self, key, text):
        try:
            issue = self.client.issues[key]
            issue.comments.create(text=text)
            logging.info("В тикете {} отписался про запуск".format(key))
        except BaseException:
            logging.warning("Такого {} тикета нет, поэтому комментарий не оставлен".format(key))
