import threading

from assessors_run.assessors_queue import AssessorsQueue, AssessorsRun
from assessors.run_assessors import make_run

_assessors_run_instances = {}


class AssessorRunner(threading.Thread):

    @classmethod
    def get_instance(cls):
        if cls not in _assessors_run_instances:
            _assessors_run_instances[cls] = cls()
        return _assessors_run_instances[cls]

    def __init__(self):
        threading.Thread.__init__(self)

        self.queue = AssessorsQueue()
        self.current_run = ''

    def add(self, run: AssessorsRun):
        self.queue.add(run)

    def run(self):
        while True:
            if self.queue.size() > 0:
                self.current_run = self.queue.get_next()
                make_run(self.current_run)
