from enum import Enum

from assessors.api_classes.testpalm import RunCreationMode


class AssessorStatus(Enum):
    waiting = 'waiting'
    started = 'started'
    startrek = 'startrek'
    testpalm = 'testpalm'
    booking = 'booking'
    hitman = 'hitman'
    finished = 'finished'
    failed = 'failed'


class BookingMode(Enum):
    custom = 'custom'
    new = 'new'
    regular = 'regular'


class AssessorsRun(object):

    def __init__(
            self,
            version_name,
            tp_project,
            special_condition,
            test_stand,
            requester,
            booking_mode: BookingMode,
            version_config_name='',
            mode: RunCreationMode = RunCreationMode.GET_FROM_CONFIG,
            filter_tp='',
            environment=[],
            run_earlier='',
            booking_id='',
    ):
        self.version_name = version_name
        self.tp_project = tp_project
        self.special_condition = special_condition
        self.test_stand = test_stand
        self.requester = requester
        self.version_config_name = version_config_name
        self.mode = mode
        self.filter_tp = filter_tp
        self.environment = environment
        self.status = AssessorStatus.waiting
        self.run_earlier = run_earlier
        self.booking_mode = BookingMode(booking_mode)
        self.booking_id = booking_id


class AssessorsQueue:

    def __init__(self):
        self.queue = []

    def add(self, run: AssessorsRun):
        self.queue.append(run)

    def get_next(self):
        return self.queue.pop(0)

    def get_all(self):
        return self.queue

    def size(self):
        return len(self.queue)
