import datetime
import json
import logging
import os

import requests
from retrying import retry

FORMAT = '%(asctime)s:%(levelname)s:%(name)s:%(message)s'
logging.basicConfig(level=logging.INFO, format=FORMAT)
log = logging.getLogger("nightlyAutotestRunner")


@retry(stop_max_attempt_number=3, wait_fixed=10000)
def send_data_to_stat(failed_classes, time, service):
    log.info(failed_classes)
    if 'mail.yandex.ru' not in failed_classes:
        log.info('no prod info')
        return

    first_day_of_current_month = datetime.date.today().strftime("%Y-%m-01")
    headers = {'Authorization': 'OAuth %s' % os.environ["STAT_TOKEN"]}
    print(first_day_of_current_month)
    r = requests.get(
        'https://upload.stat.yandex-team.ru/_api/statreport/json/Mail/Others/Fail_Test_Classes?date_min=%s&scale=d' %
        first_day_of_current_month,
        headers=headers,
    ).json()
    log.info(r)
    monthly_records = [record for record in r['values'] if record['service'] == service]
    if monthly_records:
        new_avg_failed = (sum([num['failed_num'] for num in monthly_records]) + failed_classes['mail.yandex.ru']) / \
            float(len(monthly_records) + 1)
        num_times = sum_times = 0
        for num in monthly_records:
            if num['run_time'] is not None:
                sum_times = + num['run_time']
                num_times = +1
        new_avg_time = sum_times + time['mail.yandex.ru'] / float(num_times + 1)
    else:
        new_avg_failed = failed_classes['mail.yandex.ru']
        new_avg_time = time['mail.yandex.ru']
    log.info('today awg: %s failed classes and %s mins' % (new_avg_failed, new_avg_time))
    data_day = [
        {
            'fielddate': datetime.date.today().strftime("%Y-%m-%d"),
            'service': service,
            'failed_num': failed_classes['mail.yandex.ru'],
            'run_time': time['mail.yandex.ru']
        }
    ]
    data_month = [
        {
            'fielddate': datetime.date.today().strftime("%Y-%m-01"),
            'service': service,
            'failed_num': new_avg_failed,
            'run_time': new_avg_time
        }
    ]
    r = requests.post(
        'https://upload.stat.yandex-team.ru/_api/report/data',
        headers=headers,
        data={
            'name': 'Mail/Others/Fail_Test_Classes',
            'scale': 'd',
            'data': json.dumps({'values': data_day}),
        },
    )
    log.info(r.json())
    r = requests.post(
        'https://upload.stat.yandex-team.ru/_api/report/data',
        headers=headers,
        data={
            'name': 'Mail/Others/Fail_Test_Classes',
            'scale': 'm',
            'data': json.dumps({'values': data_month}),
        },
    )
    log.info(r.json())
