# -*- coding: utf-8 -*-

import ast
from datetime import datetime, timedelta

import numpy as np
import requests
import urllib3

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

test_domains = [
    "ub1-qa.mail.yandex.ru",
    "ub2-qa.mail.yandex.ru",
    "ub3-qa.mail.yandex.ru",
    "ub4-qa.mail.yandex.ru",
    "ub5-qa.mail.yandex.ru",
    "ub6-qa.mail.yandex.ru",
    "ub7-qa.mail.yandex.ru",
    "ub8-qa.mail.yandex.ru",
    "ub9-qa.mail.yandex.ru",
    "ub10-qa.mail.yandex.ru"
]

request_url = 'https://api.error.yandex-team.ru/api/grouped_list?baseFilter=%7B%22project%22%3A%22quinn%22{}%7D&columns=%5B%22countErrors%22%2C%22countUsers%22%2C%22countRequests%22%5D&direction=DESC&field' \
              '=message&filter=%7B%22rules%22%3A%5B%7B%22column%22%3A%22domain%22%2C%22operator%22%3A%22%3D%3D%22%2C%' \
              '22value%22%3A%22{}%22%7D%5D%2C%22condition%22%3A%22AND%22%7D&limit=30&order=countErrors'

date_format = '%Y-%m-%d'
dates_day = {}
dates_month = {}
today = datetime.now()
yesterday = today + timedelta(days=-1)
dates_day['yesterday'] = '%2C%22from%22%3A%22{}%2000%3A00%3A00%22%2C%22to%22%3A%22{}%2000%3A00%3A00%22'.format(
    yesterday.strftime(date_format), today.strftime(date_format))
dates_day['today'] = '%2C%22from%22%3A%22{}%2000%3A00%3A00%22'.format(today.strftime(date_format))
for n in range(0, -21, -1):
    day = today + timedelta(days=n + 1)
    day_before = today + timedelta(days=n)
    dates_month[n] = '%2C%22from%22%3A%22{}%2000%3A00%3A00%22%2C%22to%22%3A%22{}%2000%3A00%3A00%22'.format(
        day_before.strftime(date_format), day.strftime(date_format))


def getErrors(domain, dates, unique):
    errors = {}

    for date in dates:
        errors[date] = {}
        if unique == 0:
            for test_domain in test_domains:
                r = requests.get(
                    request_url.format(dates[date], test_domain), verify=False)
                errors[date][test_domain] = r.text
        else:
            r = requests.get(
                request_url.format(dates[date], domain), verify=False)
            errors[date][domain] = r.text
    # print errors
    return errors


def get_dicts_of_errors(domain, dates, unique=True):
    prod_errors = getErrors('mail.yandex.ru', dates, True)
    test_errors = getErrors(domain, dates, unique)
    messages_test = {}
    messages_prod = {}
    for date in dates:
        messages_prod[date] = {}
        messages_test[date] = {}
        get_dicts_of_errors_inner(prod_errors[date], messages_prod[date])
        get_dicts_of_errors_inner(test_errors[date], messages_test[date])
    print(messages_test)
    return messages_prod, messages_test


def get_dicts_of_errors_inner(errors, messages):
    for dmn in errors:
        messages[dmn] = {}
        for err in ast.literal_eval(errors[dmn]):
            messages[dmn][err['message']] = err['countErrors']


def find_unique_errors(domain):
    messages_prod, messages_test = get_dicts_of_errors(domain, dates_day)
    result = {}
    for date in dates_day:
        result[date] = {}
        errors = list(set(messages_test[date][domain].keys()) - set(messages_prod[date]['mail.yandex.ru'].keys()))
        print(date)
        for item in errors:
            result[date][item] = messages_test[date][domain][item]
            print(f'{item} : {result[date][item]}')
    # print (result['yesterday'], result['today'])
    return result['yesterday'], result['today']


def find_unnormal_errors_amount(domain):
    messages_prod, messages_test = get_dicts_of_errors(domain, dates_month, False)
    result = {}
    errors = []
    for n in dates_month:
        errors = list(
            set(errors) | (set(messages_test[-1][domain].keys()) & set(messages_prod[n]['mail.yandex.ru'].keys()))
        )
    for item in errors:
        error_count = []
        for n in dates_month:
            for dmn in test_domains:
                if messages_test[n][dmn] != {}:
                    if item in messages_test[n][dmn]:
                        error_count.append(messages_test[n][dmn][item])
                    else:
                        error_count.append(0)
        pr = np.percentile(error_count, q=[25, 50, 75])
        iqr = (pr[2] - pr[0])
        if messages_test[-1][domain][item] < iqr - pr[1] or messages_test[-1][domain][item] > iqr + pr[1]:
            result[item] = messages_test[-1][domain][item]
            # print ('%s : %s' % (item, result[item]))
    return result


if __name__ == '__main__':
    find_unique_errors('')
    find_unnormal_errors_amount('')
