import logging
import os
import sys
import time
from pathlib import Path

sys.path.append(str(Path(__file__).parent.parent))
print(sys.path)

from utils.config import Constants
from set_secret import set_secret
from autotest_run.run import Run
from utils.sync_data import sync_data


dir_path = os.path.dirname(os.path.realpath(__file__))
sys.path.insert(0, dir_path)
print(sys.path)

FORMAT = '%(asctime)s:%(levelname)s:%(name)s:%(message)s'
logging.basicConfig(level=logging.INFO, format=FORMAT)
log = logging.getLogger("autotests_queue")


def sync_queue_before(fun):
    def wrapper_to_sync(self, *args, **kwargs):
        start = time.time()
        raw_queue, self._queue_last_update_timestamp = sync_data(self.json_queue,
                                                                 self._queue_last_update_timestamp,
                                                                 Constants().queue_remote_file(self.service),
                                                                 Constants().queue_local_file(self.service))
        self.queue = [{'run': Run('').from_json(run['run']), 'priority': run['priority']} for run in raw_queue]
        logging.info(f'Посинкали за {time.time() - start}')
        return_value = fun(self, *args, **kwargs)
        return return_value

    return wrapper_to_sync


def update_sync_time_after(fun):
    def wrapper_to_sync(self, *args, **kwargs):
        self._queue_last_update_timestamp = time.time()
        return_value = fun(self, *args, **kwargs)
        return return_value

    return wrapper_to_sync


class RunQueue:
    run_template = {
        "priority": 2,
        "run": Run(""),
    }

    def __init__(self, service):
        self.service = service
        self.queue = []
        # self._queue_last_update_timestamp = 0
        # self._queue_last_server_update_timestamp = 0
        # raw_queue, self._queue_last_update_timestamp = sync_data(self.json_queue,
        #                                                          self._queue_last_update_timestamp,
        #                                                          Constants().queue_remote_file(self.service),
        #                                                          Constants().queue_local_file(self.service))
        # self.queue = [{'run': Run('').from_json(run['run']), 'priority': run['priority']} for run in raw_queue]

    @property
    def json_queue(self):
        return [{'run': run['run'].to_json(), 'priority': run['priority']} for run in self.queue]

    # @update_sync_time_after
    # @sync_queue_before
    def add(self, run, priority=2):
        run_to_add = self.run_template
        run_to_add["priority"] = priority
        run_to_add["run"] = run
        i = 0
        for i in range(0, len(self.queue)):
            if priority < self.queue[i]["priority"]:
                break
            i += 1
        self.queue.insert(i, dict(run_to_add))

    # @update_sync_time_after
    # @sync_queue_before
    def get_next(self):
        next_value = self.queue.pop(0)
        return next_value

    # @sync_queue_before
    def get_all(self):
        return [run["run"] for run in self.queue]

    # @sync_queue_before
    def size(self):
        return len(self.queue)

    # @update_sync_time_after
    # @sync_queue_before
    def delete_run(self, run_id):
        i = 0
        for i in range(0, len(self.queue)):
            if self.queue[i]['run'].run_id == run_id:
                del self.queue[i]
                break
            i += 1


if __name__ == '__main__':
    set_secret.set_secrets()
