import json
import logging
import os
from pathlib import Path

FORMAT = '%(asctime)s:%(levelname)s:%(name)s:%(message)s'
logging.basicConfig(level=logging.INFO, format=FORMAT)
log = logging.getLogger("config_provider")


class Constants:
    """
    Класс позволяет переключаться между продом и тестингом чтобы отлаживать сервис. Для переключения в тестинг
    достаточно поменять дефолтное значение is_testing в конструкторе на True.
    В переменной host хранится хост, с которым происходит синхронизация, до хоста есть доступ по ssh у все группы
    тестирования почты и нашего робота.
    """

    def __init__(self, is_testing=False):
        self.is_testing = is_testing
        self.host = 'qa-mail-work.sas.yp-c.yandex.net'
        self.root_path = Path(__file__).parent.parent

    def queue_remote_file(self, service):
        """
        :param service: сервис, для которого нужна очередь
        :return: путь до файла с очередью автотестов на сервере
        """
        return f'/home/a-zoshchuk/ftp/files/queue_{service}' if not self.is_testing else f'/home/a-zoshchuk/ftp/files/queue_test_{service}'

    def queue_local_file(self, service):
        """
        :param service: сервис, для которого нужна очередь
        :return: путь до локального файла с очередью автотестов
        """
        path = f'/ephemeral/queue_{service}' if not self.is_testing else os.path.join(self.root_path,
                                                                                      f'queue_test_{service}')
        self._create_local_file_if_dont_exist_or_corrupted(path)
        return path

    @property
    def nightly_values_remote_file(self):
        """
        :return: путь до файла с очередью ночных автотестов на сервере
        """
        return '/home/a-zoshchuk/ftp/files/nightly_values' if not self.is_testing else '/home/a-zoshchuk/ftp/files/nightly_values_test'

    @property
    def nightly_values_local_file(self):
        """
        :return: путь до локального файла с очередью ночных автотестов
        """
        path = '/ephemeral/values' if not self.is_testing else os.path.join(self.root_path, 'autotest_run/values_test')
        # self._create_local_file_if_dont_exist_or_corrupted(path)
        return path

    @property
    def retries_param(self):
        retries = 'tomato.retries' if not self.is_testing else 'tomato-test.retries'
        return retries

    @property
    def id_param(self):
        id = 'tomato.id' if not self.is_testing else 'tomato-test.id'
        return id

    @property
    def emails_param(self):
        emails = 'tomato.emails' if not self.is_testing else 'tomato-test.emails'
        return emails

    @staticmethod
    def _create_local_file_if_dont_exist_or_corrupted(file):
        """
        Все данные храняться в файлах в формате `{"data": [], "last_update": int, "last_server_update": int}`. Если
        файл не соответствует формату, то он перезатрётся.
        :param file: путь к файлу на локальной машине
        :return:
        """
        try:
            with open(file, 'r', encoding='utf-8') as f:
                json.load(f)
        except Exception as e:
            log.error(e)
            log.error(f'Файл {file} не существует или испорчен, затираю и делаю чистый')
            with open(file, 'w', encoding='utf-8') as f:
                json.dump(
                    {},
                    f,
                    ensure_ascii=False
                )
