status_checklists = {
    'MAILPRODUCT': {
        'research': [
            'Провести User Hour',
            'Провести UX',
            'Собрать аналитику (примерно оценить емкость аудитории, определить влияния % на цели )',
            'Поставить задачку на концепт дизайна',
            'Защитить на продуктовой',
        ],
        'product': [
            'Описать бизнес-логику',
            'Описать user story',
            'Защитить на продуктовой финальные макеты',
            'Подготовить тексты',
            'Согласовать логику с разработкой и тестированием',
            'Подготовить дизайн эксперимента (на кого запускаем, какие будут test id и тд)',
            'Подготовить логирование с аналитиками',
            'Опционально: согласование с ИБ',
            'Опционально: согласование логики с юристами',
        ],
        'planning': [
            'Завести тикеты в разработку',
            'Получить оценку от разработки',
            'Запланировать задачку в тестировании',
            'Собрать таймлайн проекта',
            'Внести правки в документацию (ТЗ)',
        ],
        'development': [
            'Завести тикеты в MAILAN на проращивание метрик в АБ',
            'Заполнить форму на выкатку https://wiki.yandex-team.ru/users/cosmopanda/kladez-menedzherov-pochty/newfeatureform/',
            'Финализировать документацию после разработки',
            'Уточнить у тестирования, всё ли готово'
            'Запуск эксперимента',
        ],
        'experiment': [
            'Проверяем доходимость метрик на следующий день после запуска',
            'Считаем продуктовые метрики через неделю после старта',
            'Считаем денежные метрики через неделю после старта',
            'Пишем выводы и призываем аналитика',
            'Рассказываем результаты на встрече по запускам',
            'Опционально: улучшаем эксперимент',
            'Опционально: поднимаем процент эксперимента',
            'Пишем выводы по эксперименту',
            'Опционально: раскатка',
            'Опционально: отзыв эксперимента',
            'Опционально: тикет на бетонирование',
            'Опционально: тикет на выпиливание кода',
        ],
    },
    'DARIA': {
        'testing': [
            'Дизайнревью пройдено',
            'Продревью пройдено',
            'Все задачи протестированы',
            'Пройден чеклист по фиче',
            'Пройдены типовые проверки фичи',
            'Фича протестирована в проде',
        ]
    }
}

status_issues = {
    'DARIA': {
        'testing': [
            {
                'type': 'Task',
                'summary': 'Провести прод- и дизайн- ревью',
                'description': 'Запустить оба ревью, когда основная часть фичи разработана, приблизительно за пять дней до окончания разработки'
            },
            {
                'type': 'Task',
                'summary': 'Пройти чеклист по фиче',
                'description': 'Пройти написанный чеклист + типовые проверки https://forms.yandex-team.ru/surveys/86609/'
            }
        ]
    }
}

dev_issue_params = {
    'CHEMODAN': {
        'sizes_config': {
            'L': {
                'type': 'project',
            },
            'M': {
                'type': 'project',
            },
            'S': {
                'type': 'task',
            },
        },
        'service_tag': 'disk_web_services',
        'task_for_each_component': False,
        'components': {
            'Диск Веб': {
                'components': ['Disk Frontend', '#Web-client'],
            },
            'Админка B2B': {
                'components': ['Disk Frontend', '#B2B'],
            },
            'Тюнинг': {
                'components': ['Disk Frontend', '#Tuning'],
            },
            'Телемост': {
                'components': ['Disk Frontend', '#Calls'],
            },
            'Диск Паблик': {
                'components': ['Disk Frontend', '#Public'],
            },
            'Документы': {
                'components': ['Disk Frontend'],
            },
            'Редактор': {
                'components': ['Disk Frontend', '#Editor'],
            },
            'Docviewer': {
                'components': ['Disk Frontend', '#DV'],
            },
            'Заметки': {
                'components': ['Disk Frontend', '#Notes'],
            },
            'Морда': {
                'components': ['Disk Frontend', '#Auth'],
            },
            'Бэкенд': {
                'components': ['Disk Backend'],
            },
        }
    },
    'DARIA': {
        'sizes_config': {
            'L': {
                'type': 'project',
            },
            'M': {
                'type': 'project',
            },
            'S': {
                'type': 'task',
            },
        },
        'components': {}
    },
    'MAILFRONT': {
        'sizes_config': {
            'L': {
                'type': 'project',
            },
            'M': {
                'type': 'project',
            },
            'S': {
                'type': 'project',
            },
        },
        'task_for_each_component': False,
        'components': {}
    },
    'MOBDISK': {
        'sizes_config': {
            'L': {
                'type': 'newFeature',
            },
            'M': {
                'type': 'newFeature',
            },
            'S': {
                'type': 'improvement',
            },
        },
        'service_tag': 'disk_mob_services',
        'task_for_each_component': True,
        'components': {
            'Диск Android': {
                'components': ['YD Android'],
            },
            'Диск iOS': {
                'components': ['YD iOS'],
            },
        }
    },
    'MOBTEL': {
        'sizes_config': {
            'L': {
                'type': 'newFeature',
            },
            'M': {
                'type': 'newFeature',
            },
            'S': {
                'type': 'improvement',
            },
        },
        'task_for_each_component': True,
        'service_tag': 'tel_mob_services',
        'components': {
            'Телемост Android': {
                'components': ['Android'],
            },
            'Телемост iOS': {
                'components': ['iOS'],
            },
        }
    },
    'MOBILEMAIL': {
        'sizes_config': {
            'L': {
                'type': 'epic',
            },
            'M': {
                'type': 'epic',
            },
            'S': {
                'type': 'task',
            },
        },
        'task_for_each_component': False,
        'service_tag': 'mail_mob_services',
        'components': {
            'Почта Android': {
                'components': ['Android'],
            },
            'Почта iOS': {
                'components': ['iOS'],
            },
        }
    },
    'THS': {
        'sizes_config': {
            'L': {
                'type': 'project',
            },
            'M': {
                'type': 'project',
            },
            'S': {
                'type': 'task',
            },
        },
        'task_for_each_component': True,
        'service_tag': 'unknown_service',
        'components': {
            'Виджеты': {
                'components': ['Widgets'],
            },
            'Шапка': {
                'components': ['Header'],
            },
            'Нет нужного компонента': {
                'components': ['Other'],
            },
        }
    },
    'DISCSW': {
        'sizes_config': {
            'L': {
                'type': 'task',
            },
            'M': {
                'type': 'task',
            },
            'S': {
                'type': 'task',
            },
        },
        'service_tag': 'disk_po_services',
        'task_for_each_component': True,
        'components': {
            'Консольный клиент для Linux': {
                'components': ['Консольный клиент для Linux'],
            },
            'Диск Mac': {
                'components': ['Disk Mac 3.0'],
            },
            'Заметки Windows': {
                'components': ['Заметки Windows'],
            },
            'Диск Windows': {
                'components': ['Disk Windows 3.0'],
            },
            'Core': {
                'components': ['Core 3.0'],
            },
            'Телемост Windows': {
                'components': ['Telemost Windows', 'Телемост']
            },
            'Телемост Mac': {
                'components': ['Telemost Mac', 'Телемост']
            }
        }
    },
    'MSSNGR': {
        'sizes_config': {
            'L': {
                'type': 'story',
            },
            'M': {
                'type': 'story',
            },
            'S': {
                'type': 'story',
            },
        },
        'service_tag': 'messenger_services',
        'common_fields': {
            'assignee': 'doberman'
        },
        'task_for_each_component': False,
        'components': {
        }
    },
    'MAILBACKZBPTEST': {
        'sizes_config': {
            'L': {
                'type': 'project',
            },
            'M': {
                'type': 'project',
            },
            'S': {
                'type': 'task',
            },
        },
        'service_tag': 'test_services',
        'task_for_each_component': True,
        'common_fields': {
            'assignee': 'a-zoshchuk',
            'components': ['component0']
        },
        'components': {
            'Тестовый компонент1': {
                'components': ['component11', 'component12'],
                'fixVersions': ['fixVersion11'],
                'tags': ['testTag1']
            },
            'Тестовый компонент2': {
                'components': ['component21', 'component22'],
                'fixVersions': ['fixVersion21'],
                'assignee': 'assignee2',
            }
        }
    },
}
