import copy
import os

from startrek_client import Startrek

from featureFlow.flow_constants import dev_issue_params

startrek_url = 'https://st-api.yandex-team.ru'


def get_project_size(forms_size):
    """Мапим человеческий текст в значение поля размера релиза в стартреке"""
    if forms_size.find('Большой') != -1:
        return 'L'
    if forms_size.find('Средний') != -1:
        return 'M'
    if forms_size.find('Атомарный') != -1:
        return 'S'


def get_components_config(queue, answers):
    """Получаем конфиг тикета для заданной очереди и компонента"""
    keys_to_add = {}
    service_tags = []
    for queue_common in dev_issue_params:
        queue_service_tag = dev_issue_params[queue_common].get('service_tag', '')
        if queue_service_tag:
            service_tags.append(queue_service_tag)
    services = []
    for service_tag in service_tags:
        service_list = answers.get(service_tag, '').split(',')
        if service_list != ['']:
            services += map(lambda x: x.strip(), service_list)
    for form_component in services:
        if form_component in dev_issue_params[queue]['components']:
            keys_to_add[form_component] = {}
            for key in dev_issue_params[queue]['components'][form_component]:
                keys_to_add[form_component][key] = copy.deepcopy(dev_issue_params[queue]['components'][form_component][key])
    return keys_to_add


def get_service_tag_by_components(components, search_queue=''):
    """Получаем тег сервиса по компоненту"""
    for queue in dev_issue_params:
        if (search_queue != '') and (queue != search_queue):
            continue
        for tag in dev_issue_params[queue]['components']:
            if all(elem in dev_issue_params[queue]['components'][tag]['components'] for elem in components):
                return tag
    return None


def get_issue_dict_separate(issue_params, component, component_config):
    """Получаем параметры тикета для случая, когда на каждый компонент заводится отдельный тикет"""
    for key in component_config:
        if (key in issue_params) and (type(issue_params[key]) is list):
            issue_params[key] += component_config[key]
        else:
            issue_params[key] = component_config[key]
    issue_params['summary'] = f"[{component}]{issue_params['summary']}"
    return issue_params


def get_issue_dict_cumulative(issue_params, components_config):
    """Получаем параметры тикета для случая, когда на все компоненты заводитяс один тикет"""
    all_keys = {}
    for component in components_config:
        for key in components_config[component]:
            if (key in all_keys) and (type(all_keys[key]) is list):
                all_keys[key] += components_config[component][key]
            else:
                all_keys[key] = components_config[component][key]
    for key in all_keys:
        if (key in issue_params) and (type(issue_params[key]) is list):
            issue_params[key] += all_keys[key]
        else:
            issue_params[key] = all_keys[key]
    return issue_params


def get_issues_params_template(additional_args, answers):
    """Заполняем базовые параметры для тикета"""
    author = additional_args.get('manager', '')
    project_name = answers['project_name']
    feature_size = get_project_size(answers['feature_size'])
    umbrella = answers['umbrella']
    goal_id = answers['goal_id']
    is_it_crit = answers['is_it_crit'] == 'Да'
    priority_defence = answers['priority_defence']
    deadline = answers['deadline']
    description = f'\n***Описание:***\n{answers["description"]}\n\n'
    main_task = answers['main_task']
    main_service = answers['main_service']
    issue_queue = ''

    description = f'***Размер фичи:***\n{answers["feature_size"]}\n\n' + description
    if priority_defence:
        description = f'***Обоснование критичности:***\n{priority_defence}\n\n' + description
    description = f'***Зонтик:***\n{answers["umbrella"]}\n\n' + description

    for queue in dev_issue_params:
        if main_service.find(queue) != -1:
            issue_queue = queue

    issue_params = {
        "author": author if author else 'robot-pinkie-pie',
        "managerInCharge": author,
        "queue": issue_queue,
        "summary": project_name,
        "type": {'key': dev_issue_params[issue_queue]['sizes_config'][feature_size]['type']},
        "description": description,
        "deadline": deadline,
        "components": [],
        "sizeOfRelease": feature_size,
        "boards": [{"id": 26693}],
        "tags": [
            f'featureFlow_umbrella_{umbrella}'
        ]
    }
    if is_it_crit:
        issue_params['priority'] = 'critical'
    if main_task:
        weight = get_startreck_client().issues[main_task].weight
        if weight is not None:
            issue_params['weight'] = weight
        issue_params['links'] = {
            "relationship": "relates",
            "issue": main_task
        }
    if goal_id:
        issue_params['goals'] = [int(goal_id)]
    additional_fields = copy.deepcopy(dev_issue_params[issue_queue].get('common_fields', {}))
    for additional_field in additional_fields:
        issue_params[additional_field] = additional_fields[additional_field]
    return issue_params


def get_startreck_client():
    """Создаем стартрек-клиент"""
    return Startrek(
        base_url=startrek_url,
        useragent='robot-pinkie-pie',
        token=os.environ["STARTRECK_TOKEN"]
    )
