package ru.yandex.autotests.innerpochta.tests.templates;

import io.qameta.allure.junit4.Tag;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.innerpochta.rules.RestAssuredAuthRule;
import ru.yandex.autotests.innerpochta.rules.SendToStatAfterClassRule;
import ru.yandex.autotests.innerpochta.rules.acclock.AccLockRule;
import ru.yandex.autotests.innerpochta.steps.AllureStepStorage;
import ru.yandex.autotests.innerpochta.tests.BaseTest;
import ru.yandex.autotests.innerpochta.util.FeaturesConst;
import ru.yandex.autotests.innerpochta.util.Utils;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.Title;

import static ru.yandex.autotests.innerpochta.rules.ClearAccRule.clearAcc;

@Aqua.Test
@Title("Тесты на открытие шаблонов")
@Features(FeaturesConst.TEMPLATES)
@Tag(FeaturesConst.TEMPLATES)
@Stories(FeaturesConst.OPEN_TEMPLATE)
public class TemplatesOpenTest extends BaseTest {

    private AccLockRule lock = AccLockRule.use().useTusAccount();
    private RestAssuredAuthRule auth = RestAssuredAuthRule.auth(lock);
    private AllureStepStorage user = new AllureStepStorage(webDriverRule, auth);

    private String subject = Utils.getRandomString();
    private String msgText = Utils.getRandomString();

    @Rule
    public RuleChain rules = RuleChain.outerRule(lock)
            .around(auth)
            .around(clearAcc(() -> user));

    @ClassRule
    public static SendToStatAfterClassRule sendToStat = new SendToStatAfterClassRule();

    @Before
    public void logIn() {
        user.apiMessagesSteps().createTemplateMessage(lock.firstAcc(), subject, msgText);
        user.apiMessagesSteps().sendMailWithNoSave(lock.firstAcc(), Utils.getRandomString(), Utils.getRandomString());
        user.loginSteps().forAcc(lock.firstAcc()).logins();
    }

    @Test
    @Title("Открываем шаблон в пустом композе")
    @TestCaseId("5917")
    public void shouldOpenTemplatesFromEmptyCompose() {
        user.defaultSteps().clicksOn(onMessagePage().composeButton())
                .shouldSee(onComposePopup().expandedPopup())
                .clicksOn(onComposePopup().expandedPopup().templatesBtn())
                .shouldSee(onComposePopup().expandedPopup().templatePopup())
                .clicksOn(onComposePopup().expandedPopup().templatePopup().templateList().get(0))
                .shouldContainText(onComposePopup().expandedPopup().bodyInput(), msgText)
                .shouldHasValue(onComposePopup().expandedPopup().sbjInput(), subject)
                .shouldContainText(onComposePopup().yabbleTo().yabbleText(), lock.firstAcc().getSelfEmail());
    }

}