// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM file-system/file-system.ts >>>

package com.yandex.xplat.common


public interface FileSystemDirectories {
    val documentDirectory: String
    val cachesDirectory: String
}

public open class FileSystem(val directories: FileSystemDirectories, val path: FileSystemPath, private val implementation: FileSystemImplementation) {
    open fun getItemInfo(path: String): XPromise<ItemInfo> {
        return this.implementation.getItemInfo(path)
    }

    open fun exists(path: String): XPromise<Boolean> {
        return this.implementation.exists(path)
    }

    open fun listDirectory(path: String): XPromise<YSArray<String>> {
        return this.implementation.listDirectory(path)
    }

    open fun readAsString(path: String, encoding: Encoding = Encoding.Utf8, position: Long? = null, length: Long? = null): XPromise<String> {
        return this.implementation.readAsStringWithParams(path, ReadParameters(position, length, encoding))
    }

    open fun writeAsString(path: String, contents: String, encoding: Encoding = Encoding.Utf8, overwrite: Boolean = false): XPromise<Unit> {
        return this.implementation.writeAsStringWithParams(path, contents, WriteParameters(overwrite, encoding))
    }

    open fun readArrayBuffer(path: String, position: Long? = null, length: Long? = null): XPromise<ArrayBuffer> {
        return this.implementation.readArrayBufferWithParams(path, ReadParameters(position, length))
    }

    open fun writeArrayBuffer(path: String, contents: ArrayBuffer, overwrite: Boolean = false): XPromise<Unit> {
        return this.implementation.writeArrayBufferWithParams(path, contents, WriteParameters(overwrite))
    }

    open fun delete(path: String, ignoreAbsence: Boolean = false): XPromise<Unit> {
        return this.implementation.deleteWithParams(path, DeleteParameters(ignoreAbsence))
    }

    open fun move(source: String, destination: String, createIntermediates: Boolean = true, overwrite: Boolean = false): XPromise<Unit> {
        return this.implementation.moveWithParams(source, destination, MoveParameters(createIntermediates, overwrite))
    }

    open fun copy(source: String, destination: String, createIntermediates: Boolean = true): XPromise<Unit> {
        return this.implementation.copyWithParams(source, destination, CopyParameters(createIntermediates))
    }

    open fun makeDirectory(path: String, createIntermediates: Boolean = true): XPromise<Unit> {
        return this.implementation.makeDirectoryWithParams(path, MakeDirectoryParameters(createIntermediates))
    }

    open fun createNewFile(path: String, createIntermediates: Boolean = true): XPromise<Boolean> {
        return this.exists(path).flatThen(__LBL__FileSystem_1@ {
            exists ->
            if (exists) {
                return@__LBL__FileSystem_1 resolve(false)
            } else {
                val directory = this.path.dirname(path)
                return@__LBL__FileSystem_1 this.makeDirectory(directory).`catch`( {
                    _ ->
                    getVoid()
                }).flatThen( {
                    _ ->
                    this.writeAsString(path, "", Encoding.Utf8, false)
                }).then( {
                    _ ->
                    true
                })
            }
        })
    }

    open fun hash(path: String, algorithm: HashType): XPromise<String> {
        return this.implementation.hash(path, algorithm)
    }

    open fun ensureFolderExists(path: String): XPromise<Unit> {
        return this.exists(path).flatThen( {
            doesExist ->
            (if (doesExist) resolve(getVoid()) else this.makeDirectory(path, true))
        })
    }

}

