// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM file-system/file-system-implementation.ts >>>

package com.yandex.xplat.common


public interface FileSystemImplementation {
    fun getItemInfo(path: String): XPromise<ItemInfo>
    fun exists(path: String): XPromise<Boolean>
    fun listDirectory(path: String): XPromise<YSArray<String>>
    fun readAsStringWithParams(path: String, parameters: ReadParameters): XPromise<String>
    fun writeAsStringWithParams(path: String, contents: String, parameters: WriteParameters): XPromise<Unit>
    fun readArrayBufferWithParams(path: String, parameters: ReadParameters): XPromise<ArrayBuffer>
    fun writeArrayBufferWithParams(path: String, contents: ArrayBuffer, parameters: WriteParameters): XPromise<Unit>
    fun deleteWithParams(path: String, parameters: DeleteParameters): XPromise<Unit>
    fun moveWithParams(source: String, destination: String, parameters: MoveParameters): XPromise<Unit>
    fun copyWithParams(source: String, destination: String, parameters: CopyParameters): XPromise<Unit>
    fun makeDirectoryWithParams(path: String, parameters: MakeDirectoryParameters): XPromise<Unit>
    fun hash(path: String, algorithm: HashType): XPromise<String>
}

public open class ReadParameters(val position: Long?, val length: Long?, val encoding: Encoding = Encoding.Utf8) {
}

public open class WriteParameters(val overwrite: Boolean, val encoding: Encoding = Encoding.Utf8) {
}

public open class DeleteParameters(val ignoreAbsence: Boolean) {
}

public open class CopyParameters(val createIntermediates: Boolean) {
}

public open class MoveParameters(val createIntermediates: Boolean, val overwrite: Boolean) {
}

public open class MakeDirectoryParameters(val createIntermediates: Boolean) {
}

