// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM file-system/mobile-file-system-path.ts >>>

package com.yandex.xplat.common


public open class MobileFileSystemPath(override val separator: String = "/"): FileSystemPath {
    open override fun isAbsolute(p: String): Boolean {
        return p.startsWith(this.separator)
    }

    open override fun normalize(p: String): String {
        val absolute = this.isAbsolute(p)
        val trailingSeparator = p.endsWith(this.separator)
        val components = p.split(this.separator)
        val result: YSArray<String> = components.reduce(__LBL__MobileFileSystemPath_1@ {
            acc: YSArray<String>, component: String ->
            return@__LBL__MobileFileSystemPath_1 this.appendComponentToPathComponents(component, acc, absolute)
        }
, mutableListOf())
        if (result.size == 0) {
            if (absolute) {
                return this.separator
            }
            return ".${if (trailingSeparator) this.separator else ""}"
        }
        var path = result.joinToString(this.separator)
        if (trailingSeparator) {
            path += this.separator
        }
        return if (absolute) this.separator + path else path
    }

    open override fun join(paths: YSArray<String>): String {
        val joined = paths.filter( {
            item ->
            item.length > 0
        }).joinToString(this.separator)
        return if (joined.length > 0) this.normalize(joined) else "."
    }

    open override fun dirname(p: String): String {
        val path = this.removingTrailingSlashes(p)
        val chars = path.split("")
        val slash = chars.lastIndexOf(this.separator)
        if (slash == -1) {
            return "."
        }
        if (slash == 0) {
            return this.separator
        }
        return chars.slice(0, slash).joinToString("")
    }

    open override fun basename(p: String): String {
        val path = this.removingTrailingSlashes(p)
        val chars = path.split("")
        val slash = chars.lastIndexOf(this.separator)
        if (slash == -1) {
            return path
        }
        return chars.slice(slash + 1).joinToString("")
    }

    open override fun extname(p: String): String {
        val name = this.basename(p).split("")
        val dot = name.lastIndexOf(".")
        if (dot == -1) {
            return ""
        }
        if (dot == 0) {
            return ""
        }
        if (dot + 1 == name.size) {
            return "."
        }
        return name.slice(dot).joinToString("")
    }

    open override fun name(p: String): String {
        val name = this.basename(p).split("")
        val dot = name.lastIndexOf(".")
        if (dot == -1) {
            return name.joinToString("")
        }
        if (dot == 0) {
            return name.joinToString("")
        }
        return name.slice(0, dot).joinToString("")
    }

    open override fun parse(p: String): ParsedPath {
        return ParsedPath(this.dirname(p), this.basename(p), this.extname(p), this.name(p))
    }

    private fun dropLast(from: String, predicate: (String) -> Boolean): String {
        val chars = from.split("")
        for (index in (chars.size - 1 downTo 0 step 1)) {
            if (!predicate(chars[index])) {
                val substring = chars.slice(0, index + 1)
                return substring.joinToString("")
            }
        }
        return ""
    }

    private fun removingTrailingSlashes(from: String): String {
        val trimmed = this.dropLast(from,  {
            char ->
            char == this.separator
        })
        return if (trimmed.length == 0 && from.startsWith(this.separator)) this.separator else trimmed
    }

    private fun appendComponentToPathComponents(component: String, pathComponents: YSArray<String>, isAbsolute: Boolean): YSArray<String> {
        when (component) {
            "" -> {
                return pathComponents
            }
            "." -> {
                return pathComponents
            }
            ".." -> {
                if (isAbsolute) {
                    pathComponents.pop()
                    return pathComponents
                } else if (pathComponents.size > 0 && pathComponents[pathComponents.size - 1] != "..") {
                    pathComponents.pop()
                    return pathComponents
                } else {
                    pathComponents.add("..")
                    return pathComponents
                }
            }
            else -> {
                pathComponents.add(component)
                return pathComponents
            }
        }
    }

}

