// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM json/json-types.ts >>>

package com.yandex.xplat.common


public enum class JSONItemKind {
    integer,
    double,
    string,
    boolean,
    nullItem,
    map,
    array,
}
public fun JSONItemKindToString(kind: JSONItemKind): String {
    when (kind) {
        JSONItemKind.integer -> {
            return "integer"
        }
        JSONItemKind.double -> {
            return "double"
        }
        JSONItemKind.string -> {
            return "string"
        }
        JSONItemKind.boolean -> {
            return "boolean"
        }
        JSONItemKind.nullItem -> {
            return "nullItem"
        }
        JSONItemKind.map -> {
            return "map"
        }
        JSONItemKind.array -> {
            return "array"
        }
    }
}

public abstract class JSONItem protected constructor(val kind: JSONItemKind) {
    open fun isIntegerJSONItem(): Boolean {
        return this.kind == JSONItemKind.integer
    }

    open fun isDoubleJSONItem(): Boolean {
        return this.kind == JSONItemKind.double
    }

    open fun isStringJSONItem(): Boolean {
        return this.kind == JSONItemKind.string
    }

    open fun isBooleanJSONItem(): Boolean {
        return this.kind == JSONItemKind.boolean
    }

    open fun isNullJSONItem(): Boolean {
        return this.kind == JSONItemKind.nullItem
    }

    open fun isMapJSONItem(): Boolean {
        return this.kind == JSONItemKind.map
    }

    open fun isArrayJSONItem(): Boolean {
        return this.kind == JSONItemKind.array
    }

    open fun castAsIntegerJSONItem(): IntegerJSONItem? {
        return if (this.isIntegerJSONItem()) ((this as Any) as IntegerJSONItem) else null
    }

    open fun castAsDoubleJSONItem(): DoubleJSONItem? {
        return if (this.isDoubleJSONItem()) ((this as Any) as DoubleJSONItem) else null
    }

    open fun castAsStringJSONItem(): StringJSONItem? {
        return if (this.isStringJSONItem()) ((this as Any) as StringJSONItem) else null
    }

    open fun castAsBooleanJSONItem(): BooleanJSONItem? {
        return if (this.isBooleanJSONItem()) ((this as Any) as BooleanJSONItem) else null
    }

    open fun castAsNullJSONItem(): NullJSONItem? {
        return if (this.isNullJSONItem()) ((this as Any) as NullJSONItem) else null
    }

    open fun castAsMapJSONItem(): MapJSONItem? {
        return if (this.isMapJSONItem()) ((this as Any) as MapJSONItem) else null
    }

    open fun castAsArrayJSONItem(): ArrayJSONItem? {
        return if (this.isArrayJSONItem()) ((this as Any) as ArrayJSONItem) else null
    }

    open fun tryCastAsIntegerJSONItem(): IntegerJSONItem {
        return requireNotNull(this.castAsIntegerJSONItem(), JSONParsingError.tryCastFailed(this, JSONItemKind.integer))
    }

    open fun tryCastAsDoubleJSONItem(): DoubleJSONItem {
        return requireNotNull(this.castAsDoubleJSONItem(), JSONParsingError.tryCastFailed(this, JSONItemKind.double))
    }

    open fun tryCastAsStringJSONItem(): StringJSONItem {
        return requireNotNull(this.castAsStringJSONItem(), JSONParsingError.tryCastFailed(this, JSONItemKind.string))
    }

    open fun tryCastAsBooleanJSONItem(): BooleanJSONItem {
        return requireNotNull(this.castAsBooleanJSONItem(), JSONParsingError.tryCastFailed(this, JSONItemKind.boolean))
    }

    open fun tryCastAsNullJSONItem(): NullJSONItem {
        return requireNotNull(this.castAsNullJSONItem(), JSONParsingError.tryCastFailed(this, JSONItemKind.nullItem))
    }

    open fun tryCastAsMapJSONItem(): MapJSONItem {
        return requireNotNull(this.castAsMapJSONItem(), JSONParsingError.tryCastFailed(this, JSONItemKind.map))
    }

    open fun tryCastAsArrayJSONItem(): ArrayJSONItem {
        return requireNotNull(this.castAsArrayJSONItem(), JSONParsingError.tryCastFailed(this, JSONItemKind.array))
    }

}

public open class IntegerJSONItem private constructor(private val value: Long, val isInt64: Boolean): JSONItem(JSONItemKind.integer) {
    open fun asInt32(): Int {
        return int64ToInt32(this.value)
    }

    open fun asInt64(): Long {
        return this.value
    }

    companion object {
        @JvmStatic
        open fun fromInt32(value: Int): IntegerJSONItem {
            return IntegerJSONItem(int32ToInt64(value), false)
        }

        @JvmStatic
        open fun fromInt64(value: Long): IntegerJSONItem {
            return IntegerJSONItem(value, true)
        }

    }
}

public open class DoubleJSONItem(val value: Double): JSONItem(JSONItemKind.double) {
}

public open class StringJSONItem(val value: String): JSONItem(JSONItemKind.string) {
}

public open class BooleanJSONItem(val value: Boolean): JSONItem(JSONItemKind.boolean) {
}

public open class NullJSONItem(): JSONItem(JSONItemKind.nullItem) {
}

public open class MapJSONItem(private val value: YSMap<String, JSONItem> = mutableMapOf<String, JSONItem>()): JSONItem(JSONItemKind.map) {
    open fun asMap(): YSMap<String, JSONItem> {
        return this.value
    }

    open fun put(key: String, value: JSONItem): MapJSONItem {
        this.value.set(key, value)
        return this
    }

    open fun putIfPresent(key: String, value: JSONItem?): MapJSONItem {
        if (value != null) {
            this.value.set(key, value)
        }
        return this
    }

    open fun putInt32(key: String, value: Int): MapJSONItem {
        this.value.set(key, IntegerJSONItem.fromInt32(value))
        return this
    }

    open fun putInt32IfPresent(key: String, value: Int?): MapJSONItem {
        if (value != null) {
            this.putInt32(key, value!!)
        }
        return this
    }

    open fun putInt64(key: String, value: Long): MapJSONItem {
        this.value.set(key, IntegerJSONItem.fromInt64(value))
        return this
    }

    open fun putInt64IfPresent(key: String, value: Long?): MapJSONItem {
        if (value != null) {
            this.putInt64(key, value!!)
        }
        return this
    }

    open fun putDouble(key: String, value: Double): MapJSONItem {
        this.value.set(key, DoubleJSONItem(value))
        return this
    }

    open fun putBoolean(key: String, value: Boolean): MapJSONItem {
        this.value.set(key, BooleanJSONItem(value))
        return this
    }

    open fun putString(key: String, value: String): MapJSONItem {
        this.value.set(key, StringJSONItem(value))
        return this
    }

    open fun putStringIfPresent(key: String, value: String?): MapJSONItem {
        if (value != null) {
            this.putString(key, value!!)
        }
        return this
    }

    open fun putNull(key: String): MapJSONItem {
        this.value.set(key, NullJSONItem())
        return this
    }

    open fun `get`(key: String): JSONItem? {
        return undefinedToNull(this.value.get(key))
    }

    open fun getArray(key: String): YSArray<JSONItem>? {
        val result = undefinedToNull(this.value.get(key))
        if (result == null || result.kind != JSONItemKind.array) {
            return null
        }
        return (result as ArrayJSONItem).asArray()
    }

    open fun getArrayOrDefault(key: String, value: YSArray<JSONItem>): YSArray<JSONItem> {
        return this.getArray(key) ?: value
    }

    open fun getMap(key: String): YSMap<String, JSONItem>? {
        val result = undefinedToNull(this.value.get(key))
        if (result == null || result.kind != JSONItemKind.map) {
            return null
        }
        return (result as MapJSONItem).asMap()
    }

    open fun getMapOrDefault(key: String, value: YSMap<String, JSONItem>): YSMap<String, JSONItem> {
        return this.getMap(key) ?: value
    }

    open fun getInt32(key: String): Int? {
        val result = undefinedToNull(this.value.get(key))
        if (result == null) {
            return null
        }
        return JSONItemToInt32(result)
    }

    open fun getInt32OrDefault(key: String, value: Int): Int {
        return this.getInt32(key) ?: value
    }

    open fun getInt64(key: String): Long? {
        val result = undefinedToNull(this.value.get(key))
        if (result == null) {
            return null
        }
        return JSONItemToInt64(result)
    }

    open fun getInt64OrDefault(key: String, value: Long): Long {
        return this.getInt64(key) ?: value
    }

    open fun getDouble(key: String): Double? {
        val result = undefinedToNull(this.value.get(key))
        if (result == null) {
            return null
        }
        return JSONItemToDouble(result)
    }

    open fun getDoubleOrDefault(key: String, value: Double): Double {
        return this.getDouble(key) ?: value
    }

    open fun getBoolean(key: String): Boolean? {
        val result = undefinedToNull(this.value.get(key))
        if (result == null || result.kind != JSONItemKind.boolean) {
            return null
        }
        return (result as BooleanJSONItem).value
    }

    open fun getBooleanOrDefault(key: String, value: Boolean): Boolean {
        return this.getBoolean(key) ?: value
    }

    open fun getString(key: String): String? {
        val result = undefinedToNull(this.value.get(key))
        if (result == null || result.kind != JSONItemKind.string) {
            return null
        }
        return (result as StringJSONItem).value
    }

    open fun getStringOrDefault(key: String, value: String): String {
        return this.getString(key) ?: value
    }

    open fun tryGetInt32(key: String): Int {
        return requireNotNull(this.getInt32(key), JSONParsingError.mapTryGetFailed(this, key, JSONItemKind.integer))
    }

    open fun tryGetInt64(key: String): Long {
        return requireNotNull(this.getInt64(key), JSONParsingError.mapTryGetFailed(this, key, JSONItemKind.integer))
    }

    open fun tryGetDouble(key: String): Double {
        return requireNotNull(this.getDouble(key), JSONParsingError.mapTryGetFailed(this, key, JSONItemKind.double))
    }

    open fun tryGetString(key: String): String {
        return requireNotNull(this.getString(key), JSONParsingError.mapTryGetFailed(this, key, JSONItemKind.string))
    }

    open fun tryGetBoolean(key: String): Boolean {
        return requireNotNull(this.getBoolean(key), JSONParsingError.mapTryGetFailed(this, key, JSONItemKind.boolean))
    }

    open fun tryGetMap(key: String): YSMap<String, JSONItem> {
        return requireNotNull(this.getMap(key), JSONParsingError.mapTryGetFailed(this, key, JSONItemKind.map))
    }

    open fun tryGetArray(key: String): YSArray<JSONItem> {
        return requireNotNull(this.getArray(key), JSONParsingError.mapTryGetFailed(this, key, JSONItemKind.array))
    }

    open fun isNull(key: String): Boolean {
        val result = undefinedToNull(this.value.get(key))
        if (result == null) {
            return false
        }
        return result.kind == JSONItemKind.nullItem
    }

    open fun hasKey(key: String): Boolean {
        return undefinedToNull(this.value.get(key)) != null
    }

}

public open class ArrayJSONItem(private val value: YSArray<JSONItem> = mutableListOf()): JSONItem(JSONItemKind.array) {
    open fun asArray(): YSArray<JSONItem> {
        return this.value
    }

    open fun getCount(): Int {
        return this.value.size
    }

    open fun add(value: JSONItem): ArrayJSONItem {
        this.value.add(value)
        return this
    }

    open fun addInt32(value: Int): ArrayJSONItem {
        this.value.add(IntegerJSONItem.fromInt32(value))
        return this
    }

    open fun addInt64(value: Long): ArrayJSONItem {
        this.value.add(IntegerJSONItem.fromInt64(value))
        return this
    }

    open fun addDouble(value: Double): ArrayJSONItem {
        this.value.add(DoubleJSONItem(value))
        return this
    }

    open fun addBoolean(value: Boolean): ArrayJSONItem {
        this.value.add(BooleanJSONItem(value))
        return this
    }

    open fun addString(value: String): ArrayJSONItem {
        this.value.add(StringJSONItem(value))
        return this
    }

    open fun addNull(): ArrayJSONItem {
        this.value.add(NullJSONItem())
        return this
    }

    open fun `get`(index: Int): JSONItem {
        if (index < 0 || index >= this.value.size) {
            throw Error("Index is out of bounds")
        }
        return this.value[index]
    }

    open fun getMap(index: Int): YSMap<String, JSONItem> {
        if (index < 0 || index >= this.value.size) {
            throw Error("Index is out of bounds")
        }
        val result = this.value[index]
        if (result.kind != JSONItemKind.map) {
            throw Error("Type is not ${JSONItemKind.map} at index ${index}. It's ${result.kind}")
        }
        return (result as MapJSONItem).asMap()
    }

    open fun getArray(index: Int): YSArray<JSONItem> {
        if (index < 0 || index >= this.value.size) {
            throw Error("Index is out of bounds")
        }
        val result = this.value[index]
        if (result.kind != JSONItemKind.array) {
            throw Error("Type is not ${JSONItemKind.array} at index ${index}. It's ${result.kind}")
        }
        return (result as ArrayJSONItem).asArray()
    }

    open fun getInt32(index: Int): Int {
        if (index < 0 || index >= this.value.size) {
            throw Error("Index is out of bounds")
        }
        val value = this.value[index]
        val result: Int? = JSONItemToInt32(value)
        if (result != null) {
            return result
        }
        throw Error("Type is not Int32 at index ${index}. It's ${value.kind}")
    }

    open fun getInt64(index: Int): Long {
        if (index < 0 || index >= this.value.size) {
            throw Error("Index is out of bounds")
        }
        val value = this.value[index]
        val result: Long? = JSONItemToInt64(value)
        if (result != null) {
            return result
        }
        throw Error("Type is not Int64 at index ${index}. It's ${value.kind}")
    }

    open fun getDouble(index: Int): Double {
        if (index < 0 || index >= this.value.size) {
            throw Error("Index is out of bounds")
        }
        val value = this.value[index]
        val result: Double? = JSONItemToDouble(value)
        if (result != null) {
            return result
        }
        throw Error("Type is not Double at index ${index}. It's ${value.kind}")
    }

    open fun getBoolean(index: Int): Boolean {
        if (index < 0 || index >= this.value.size) {
            throw Error("Index is out of bounds")
        }
        val result = this.value[index]
        if (result.kind != JSONItemKind.boolean) {
            throw Error("Type is not ${JSONItemKind.boolean} at index ${index}. It's ${result.kind}")
        }
        return (result as BooleanJSONItem).value
    }

    open fun getString(index: Int): String {
        if (index < 0 || index >= this.value.size) {
            throw Error("Index is out of bounds")
        }
        val result = this.value[index]
        if (result.kind != JSONItemKind.string) {
            throw Error("Type is not ${JSONItemKind.string} at index ${index}. It's ${result.kind}")
        }
        return (result as StringJSONItem).value
    }

    open fun isNull(index: Int): Boolean {
        if (index < 0 || index >= this.value.size) {
            throw Error("Index is out of bounds")
        }
        return this.value[index].kind == JSONItemKind.nullItem
    }

}

public fun JSONItemToInt32(item: JSONItem): Int? {
    when (item.kind) {
        JSONItemKind.double -> {
            return doubleToInt32((item as DoubleJSONItem).value)
        }
        JSONItemKind.integer -> {
            return (item as IntegerJSONItem).asInt32()
        }
        JSONItemKind.string -> {
            return stringToInt32((item as StringJSONItem).value)
        }
        else -> {
            return null
        }
    }
}

public fun JSONItemToInt64(item: JSONItem): Long? {
    when (item.kind) {
        JSONItemKind.double -> {
            return doubleToInt64((item as DoubleJSONItem).value)
        }
        JSONItemKind.integer -> {
            return (item as IntegerJSONItem).asInt64()
        }
        JSONItemKind.string -> {
            return stringToInt64((item as StringJSONItem).value)
        }
        else -> {
            return null
        }
    }
}

public fun JSONItemToDouble(item: JSONItem): Double? {
    when (item.kind) {
        JSONItemKind.double -> {
            return (item as DoubleJSONItem).value
        }
        JSONItemKind.integer -> {
            return int64ToDouble((item as IntegerJSONItem).asInt64())
        }
        JSONItemKind.string -> {
            return stringToDouble((item as StringJSONItem).value)
        }
        else -> {
            return null
        }
    }
}

public fun JSONItemGetValue(item: JSONItem): Any? {
    when (item.kind) {
        JSONItemKind.string -> {
            return (item as StringJSONItem).value
        }
        JSONItemKind.boolean -> {
            return (item as BooleanJSONItem).value
        }
        JSONItemKind.integer -> {
            val i = item as IntegerJSONItem
            return if (i.isInt64) i.asInt64() else i.asInt32()
        }
        JSONItemKind.double -> {
            return (item as DoubleJSONItem).value
        }
        JSONItemKind.array -> {
            return (item as ArrayJSONItem).asArray().map( {
                `it` ->
                JSONItemGetValue(`it`)
            })
        }
        JSONItemKind.map -> {
            val res = mutableMapOf<String, Any>()
            (item as MapJSONItem).asMap().__forEach(__LBL__JsonTypes_1@ {
                v, k ->
                val `val` = JSONItemGetValue(v)
                if (`val` != null) {
                    res.set(k, `val`)
                }
            })
            return res
        }
        else -> {
            return null
        }
    }
}

public fun JSONItemGetValueDebugDescription(item: JSONItem): String {
    when (item.kind) {
        JSONItemKind.integer -> {
            return int64ToString((item as IntegerJSONItem).asInt64())
        }
        JSONItemKind.double -> {
            return doubleToString((item as DoubleJSONItem).value)
        }
        JSONItemKind.string -> {
            return quote((item as StringJSONItem).value)
        }
        JSONItemKind.boolean -> {
            return if ((item as BooleanJSONItem).value) "true" else "false"
        }
        JSONItemKind.nullItem -> {
            return "null"
        }
        JSONItemKind.map -> {
            val map = item as MapJSONItem
            val mapValues: YSArray<String> = mutableListOf()
            map.asMap().__forEach(__LBL__JsonTypes_2@ {
                value: JSONItem, key: String ->
                mapValues.add("\"${key}\": ${JSONItemGetDebugDescription(value)}")
            })
            return "{${mapValues.join(", ")}}"
        }
        JSONItemKind.array -> {
            val array = item as ArrayJSONItem
            val arrayValues: YSArray<String> = array.asArray().map( {
                value ->
                JSONItemGetDebugDescription(value)
            })
            return "[${arrayValues.join(", ")}]"
        }
    }
}

public fun JSONItemGetDebugDescription(item: JSONItem): String {
    val valueDescription = JSONItemGetValueDebugDescription(item)
    return "<JSONItem kind: ${JSONItemKindToString(item.kind)}, value: ${valueDescription}>"
}

public fun <T> decodeJSONItem(item: JSONItem, materializer: (JSONItem) -> T): Result<T> {
    try {
        val value: T = materializer(item)
        return resultValue(value)
    } catch (e: RuntimeException) {
        if (e is YSError) {
            return resultError(JSONParsingError.deserializationFailed(item, e as YSError))
        } else {
            return resultError(JSONParsingError.unknownDeserializationError(item, e))
        }
    }
}

public open class JSONParsingError private constructor(message: String): YSError(message) {
    companion object {
        @JvmStatic
        open fun tryCastFailed(item: JSONItem, target: JSONItemKind): JSONParsingError {
            return JSONParsingError("Failed to cast JSONItem of kind \"${JSONItemKindToString(item.kind)}\" to kind \"${JSONItemKindToString(target)}\", json: \"${JSONItemGetDebugDescription(item)}\"")
        }

        @JvmStatic
        open fun mapTryGetFailed(item: JSONItem, key: String, target: JSONItemKind): JSONParsingError {
            return JSONParsingError("Failed to query MapJSONItem for key \"${key}\" of kind \"${JSONItemKindToString(target)}\", json: \"${JSONItemGetDebugDescription(item)}\"")
        }

        @JvmStatic
        open fun deserializationFailed(item: JSONItem, error: YSError): JSONParsingError {
            return JSONParsingError("Failed to deserialize JSONItem: \"${JSONItemGetDebugDescription(item)}\", error: \"${error.message}\"")
        }

        @JvmStatic
        open fun unknownDeserializationError(item: JSONItem, error: Any): JSONParsingError {
            return JSONParsingError("Failed to deserialize JSONItem: \"${JSONItemGetDebugDescription(item)}\", unkown error: \"${error}\"")
        }

    }
}

