// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM network/network-request.ts >>>

package com.yandex.xplat.common


public typealias NetworkParams = MapJSONItem

public typealias NetworkUrlExtra = MapJSONItem

public typealias NetworkHeadersExtra = MapJSONItem

public enum class NetworkMethod(val value: String) {
    get("get"),
    post("post"),
    ;
    override fun toString(): String = value
}
public enum class RequestEncodingKind {
    url,
    json,
}
public interface RequestEncoding {
    val kind: RequestEncodingKind
}

public open class UrlRequestEncoding: RequestEncoding {
    override val kind: RequestEncodingKind = RequestEncodingKind.url
}

public open class JsonRequestEncoding: RequestEncoding {
    override val kind: RequestEncodingKind = RequestEncodingKind.json
}

public interface NetworkRequest {
    fun method(): NetworkMethod
    fun targetPath(): String
    fun params(): NetworkParams
    fun urlExtra(): NetworkUrlExtra
    fun headersExtra(): NetworkHeadersExtra
    fun encoding(): RequestEncoding
}

public abstract class BaseNetworkRequest(): NetworkRequest {
    abstract override fun method(): NetworkMethod
    abstract override fun targetPath(): String
    open override fun params(): NetworkParams {
        return MapJSONItem()
    }

    open override fun urlExtra(): NetworkUrlExtra {
        return MapJSONItem()
    }

    open override fun headersExtra(): NetworkHeadersExtra {
        return MapJSONItem()
    }

    abstract override fun encoding(): RequestEncoding
}

public open class SealedNetworkRequest(private val _method: NetworkMethod, private val _targetPath: String, private val _params: MapJSONItem, private val _urlExtra: MapJSONItem, private val _headersExtra: NetworkHeadersExtra, private val _encoding: RequestEncoding): NetworkRequest {
    open override fun method(): NetworkMethod {
        return this._method
    }

    open override fun targetPath(): String {
        return this._targetPath
    }

    open override fun params(): MapJSONItem {
        return this._params
    }

    open override fun urlExtra(): MapJSONItem {
        return this._urlExtra
    }

    open override fun headersExtra(): NetworkHeadersExtra {
        return this._headersExtra
    }

    open override fun encoding(): RequestEncoding {
        return this._encoding
    }

}

