// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM utils/collections.ts >>>

package com.yandex.xplat.common


public open class Collections {
    companion object {
        @JvmStatic
        open fun <T> maxInt64(items: YSArray<T>, fetch: (T) -> Long): Long? {
            if (items.size == 0) {
                return null
            }
            var result = fetch(items[0])
            for (index in (1 until items.size step 1)) {
                val value = fetch(items[index])
                if (value > result) {
                    result = value
                }
            }
            return result
        }

        @JvmStatic
        open fun <T> maxInt32(items: YSArray<T>, fetch: (T) -> Int): Int? {
            if (items.size == 0) {
                return null
            }
            var result = fetch(items[0])
            for (index in (1 until items.size step 1)) {
                val value = fetch(items[index])
                if (value > result) {
                    result = value
                }
            }
            return result
        }

        @JvmStatic
        open fun <T> sumBy(items: YSArray<T>, fetch: (T) -> Int): Int {
            var sum: Int = 0
            for (element in items) {
                sum += fetch(element)
            }
            return sum
        }

        @JvmStatic
        open fun <T> flatten(array: YSArray<YSArray<T>>): YSArray<T> {
            return array.reduce( {
                acc: YSArray<T>, `val`: YSArray<T> ->
                acc.concat(`val`)
            }
, mutableListOf())
        }

        @JvmStatic
        open fun <T> setMinus(a: YSSet<T>, b: YSSet<T>): YSSet<T> {
            val items = setToArray(a).filter( {
                item ->
                !b.has(item)
            })
            return arrayToSet(items)
        }

        @JvmStatic
        open fun <T, U, Z> zip2With(first: YSArray<T>, second: YSArray<U>, zipper: (T, U) -> Z): YSArray<Z> {
            val minLen = if (first.size < second.size) first.size else second.size
            val result: YSArray<Z> = mutableListOf()
            for (index in (0 until minLen step 1)) {
                result.add(zipper(first[index], second[index]))
            }
            return result
        }

        @JvmStatic
        open fun <T> setIntersect(a: YSSet<T>, b: YSSet<T>): YSSet<T> {
            return arrayToSet(setToArray(a).filter( {
                i ->
                b.has(i)
            }))
        }

        @JvmStatic
        open fun <T> setSubtract(a: YSSet<T>, b: YSSet<T>): YSSet<T> {
            return arrayToSet(setToArray(a).filter( {
                i ->
                !b.has(i)
            }))
        }

        @JvmStatic
        open fun <K, V, R> mapKeys(map: YSMap<K, V>, transform: (K) -> R): YSMap<R, V> {
            val result = mutableMapOf<R, V>()
            map.__forEach(__LBL__Collections_1@ {
                value, key ->
                result.set(transform(key), value)
            })
            return result
        }

        @JvmStatic
        open fun <T, R> mapNotNull(array: YSArray<T>, transform: (T) -> R?): YSArray<R> {
            val result = mutableListOf<R>()
            array.forEach(__LBL__Collections_2@ {
                value ->
                val newValue = transform(value)
                if (newValue != null) {
                    result.add(newValue)
                }
            })
            return result
        }

    }
}

