// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM utils/polling.ts >>>

package com.yandex.xplat.common


public enum class PollingStep(val value: String) {
    retry("retry"),
    done("done"),
    ;
    override fun toString(): String = value
}
public open class PollingOptions(val retries: Int?, val nextIntervalStrategy: PollingNextIntervalStrategy?, val timeoutMs: Long?, val cancellationToken: CancellationToken?) {
    companion object {
        @JvmStatic
        open fun indefinite(): PollingOptions {
            return PollingOptions(null, null, null, null)
        }

    }
}

public fun <T> startPolling(taskFn: () -> XPromise<T>, checkResult: (T) -> Result<PollingStep>, options: PollingOptions = PollingOptions.indefinite()): XPromise<T> {
    val polling = PollingFunctor(taskFn, checkResult, options)
    return polling.poll()
}

public open class CancellationToken() {
    private var cancelled: Boolean = false
    open fun cancel(): Unit {
        this.cancelled = true
    }

    open fun isCancelled(): Boolean {
        return this.cancelled
    }

}

public interface PollingNextIntervalStrategy {
    fun getNextIntervalMs(count: Int): Long
}

public open class PollingFixedIntervalStrategy(private val interval: Long): PollingNextIntervalStrategy {
    open override fun getNextIntervalMs(count: Int): Long {
        return this.interval
    }

}

public open class PollingFunctor<T>(private val taskFn: () -> XPromise<T>, private val checkResult: (T) -> Result<PollingStep>, private val options: PollingOptions) {
    private var retriesCounter: Int = 0
    private val startTimeMs: Long = int64(YSDate.now())
    open fun poll(): XPromise<T> {
        if (this.options.cancellationToken?.isCancelled() ?: false) {
            return reject<T>(YSError("Polling cancelled"))
        }
        val promise = this.taskFn().flatThen(__LBL__Polling_1@ {
            res: T ->
            val nextStepResult = this.checkResult(res)
            if (nextStepResult.isError()) {
                return@__LBL__Polling_1 reject<T>(nextStepResult.getError())
            }
            val nextStep = nextStepResult.getValue()
            if (nextStep == PollingStep.done) {
                return@__LBL__Polling_1 resolve<T>(res)
            }
            return@__LBL__Polling_1 this.retry()
        })
        return promise
    }

    private fun retry(): XPromise<T> {
        this.retriesCounter = this.retriesCounter + 1
        if (this.options.retries != null && this.retriesCounter > this.options.retries!!) {
            return reject<T>(YSError("Maximum retries count reached"))
        }
        val elapsedTimeMs = int64(YSDate.now()) - this.startTimeMs
        if (this.options.timeoutMs != null && elapsedTimeMs > this.options.timeoutMs!!) {
            return reject<T>(YSError("Timeout reached"))
        }
        val delayMs = this.options.nextIntervalStrategy?.getNextIntervalMs(this.retriesCounter) ?: int64(0)
        return delayed(getVoid(), delayMs).flatThen( {
            _ ->
            this.poll()
        })
    }

}

