// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM eventus-event.ts >>>

package com.yandex.xplat.eventus.common

import com.yandex.xplat.common.*

public open class EventusConstants {
    companion object {
        @JvmStatic val ERROR: String = "ERROR"
        @JvmStatic val PREFIX: String = "EVENTUS_"
        @JvmStatic val SUCCESS_SUFFIX: String = "_success"
        @JvmStatic val FAILURE_SUFFIX: String = "_failure"
        @JvmStatic val EVENTUS_ID: String = "eventus_id"
        @JvmStatic val ORIGIN_EVENTUS_ID: String = "origin_eventus_id"
    }
}

public open class EventusEvent private constructor(val name: String, builder: ValueMapBuilder) {
    private val value: YSMap<String, JSONItem>
    init {
        this.value = builder.setEventName(name).build()
    }
    open fun getAttributes(): YSMap<String, Any> {
        val result = mutableMapOf<String, Any>()
        this.value.__forEach(__LBL__EventusEvent_1@ {
            v, k ->
            val `val` = JSONItemGetValue(v)
            if (`val` != null) {
                result.set(k, `val`)
            }
        })
        return result
    }

    open fun getInt64(attribute: String): Long? {
        val value = undefinedToNull(this.value.get(attribute))
        if (value == null) {
            return null
        }
        if (value!!.kind != JSONItemKind.integer) {
            return null
        }
        return (value as IntegerJSONItem).asInt64()
    }

    open fun getInt32(attribute: String): Int? {
        val value = undefinedToNull(this.value.get(attribute))
        if (value == null) {
            return null
        }
        if (value!!.kind != JSONItemKind.integer) {
            return null
        }
        return (value as IntegerJSONItem).asInt32()
    }

    open fun reportVia(reporter: EventReporter): Unit {
        var aggregator = EventusRegistry.aggregatorProvider().getAggregator()
        if (EventusRegistry.aggregatorProvider().updateAggregator(this)) {
            EventusEvent.reportIfPresent(reporter, aggregator.finalize())
            aggregator = EventusRegistry.aggregatorProvider().getAggregator()
        }
        EventusEvent.reportIfPresent(reporter, aggregator.accept(this))
    }

    open fun report(): Unit {
        this.reportVia(EventusRegistry.eventReporter())
    }

    open fun success(moreValues: ValueMapBuilder? = null): EventusEvent {
        val eventName = this.name + EventusConstants.SUCCESS_SUFFIX
        val originEventusId = this.getInt64(EventusConstants.EVENTUS_ID)
        if (originEventusId == null) {
            return EventusEvent.eventCreationErrorEvent(eventName, "Origin eventus id was not found")
        }
        var values = ValueMapBuilder.__parse(this.value).addOriginEventusId(originEventusId!!)
        if (moreValues != null) {
            values = values.__plus(moreValues!!)
        }
        return EventusEvent.newClientEvent(eventName, values)
    }

    open fun failure(reason: String? = null, moreValues: ValueMapBuilder? = null): EventusEvent {
        val eventName = this.name + EventusConstants.FAILURE_SUFFIX
        val originEventusId = this.getInt64(EventusConstants.EVENTUS_ID)
        if (originEventusId == null) {
            return EventusEvent.eventCreationErrorEvent(eventName, "Origin eventus id was not found")
        }
        var values = ValueMapBuilder.__parse(this.value).addOriginEventusId(originEventusId!!).addError().addReason(reason)
        if (moreValues != null) {
            values = values.__plus(moreValues!!)
        }
        return EventusEvent.newClientEvent(eventName, values)
    }

    open fun <T> traceExecution(promise: XPromise<T>): XPromise<T> {
        val start = EventusRegistry.timeProvider.getCurrentTimeMs()
        val getTimespanParams = __LBL__EventusEvent_2@ {
             ->
            val timespan = EventusRegistry.timeProvider.getCurrentTimeMs() - start
            val emptyBuilder = ValueMapBuilder.__parse(mutableMapOf())
            return@__LBL__EventusEvent_2 emptyBuilder.addTimespan(timespan)
        }

        this.report()
        promise.then( {
            _ ->
            this.success(getTimespanParams()).report()
        }).`catch`( {
            e ->
            this.failure(e.message, getTimespanParams()).report()
        })
        return promise
    }

    companion object {
        @JvmStatic
        open fun fromMap(name: String, attributes: YSMap<String, JSONItem> = mutableMapOf()): EventusEvent {
            return EventusEvent(name, ValueMapBuilder.__parse(attributes))
        }

        @JvmStatic
        open fun newClientEvent(name: String, builder: ValueMapBuilder = ValueMapBuilder.userEvent()): EventusEvent {
            val id = EventusRegistry.eventIdProvider.getId()
            builder.addEventusId(id)
            builder.setEventName(name)
            return EventusEvent(name, builder)
        }

        @JvmStatic
        open fun eventCreationErrorEvent(event: String, reason: String): EventusEvent {
            return EventusEvent(EventusConstants.ERROR, ValueMapBuilder.customEvent("error").addError().addReason(reason).addEvent(event))
        }

        @JvmStatic
        private fun reportIfPresent(reporter: EventReporter, event: EventusEvent?): Unit {
            if (event != null) {
                reporter.report(LoggingEvent.fromEventusEvent(event))
            }
        }

    }
}

public open class LoggingEvent(val name: String, val attributes: YSMap<String, Any>) {
    companion object {
        @JvmStatic
        open fun fromEventusEvent(event: EventusEvent): LoggingEvent {
            val attributes = event.getAttributes()
            attributes.set("timestamp", EventusRegistry.timeProvider.getCurrentTimeMs())
            attributes.set("version", EventusRegistry.version)
            return LoggingEvent(LoggingEvent.getFormattedName(event.name), attributes)
        }

        @JvmStatic
        open fun getFormattedName(eventName: String): String {
            return EventusConstants.PREFIX + eventName
        }

    }
}

